/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.data;

import bikframework.config.data.IPropertyData;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDataChangeListener<T extends IPropertyData> {
    public static final Logger logger = LoggerFactory.getLogger(IDataChangeListener.class);

    public List<T> queryData(long var1);

    default public void processData(T object, Map<String, String> properties) {
        String key = object.buildKey();
        String v = Strings.nullToEmpty((String)properties.get(key));
        if (object.getStatus() == 0) {
            if (!Strings.isNullOrEmpty((String)v)) {
                properties.remove(key);
                logger.info("[DataLoader][delete][{}]=[{}]", (Object)key, (Object)object.getValue());
            }
        } else {
            properties.put(key, object.getValue());
            logger.info("[DataLoader][Update][{}]=[{}->{}]", new Object[]{key, v, object.getValue()});
        }
    }
}

