/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.file.monitor;

import bikframework.config.config.ConfigValueTools;
import bikframework.config.config.listener.IConfigChangeListener;
import bikframework.config.configcenter.common.ConfigOverrideTools;
import bikframework.config.file.monitor.FileChangeListenerAdaptor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentListener
extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(FileContentListener.class);
    private IConfigChangeListener listener;

    public FileContentListener(boolean backupAfterProcess, IConfigChangeListener listener) {
        super(backupAfterProcess);
        this.listener = listener;
    }

    @Override
    public void onFileCreate(File file) {
        this.loadFile(file);
    }

    @Override
    public void onFileChange(File file) {
        this.loadFile(file);
    }

    public void onFileDelete(File file) {
    }

    public void loadFile(File file) {
        try {
            String dataId = FilenameUtils.getName((String)file.getName());
            ConfigValueTools.registerListener(dataId, ConfigOverrideTools.getConfigFileWight(dataId), this.listener);
            ConfigValueTools.update(dataId, FileUtils.readFileToString((File)file, (String)"UTF-8"));
        }
        catch (IOException e) {
            logger.warn("load file exception:{},fileName:{}", (Object)e.getMessage(), (Object)file.getName());
        }
    }
}

