/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.file.monitor;

import bikframework.config.file.monitor.IFileChangedFilter;
import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class FileNameFilter
extends AbstractFileFilter
implements IFileChangedFilter {
    protected String fnp;

    public FileNameFilter(String fn) {
        this.fnp = fn;
    }

    public boolean accept(File file) {
        if (!file.isFile()) {
            return false;
        }
        return this.accept(this.fnp, file.getName());
    }

    public boolean accept(File dir, String name) {
        return this.accept(this.fnp, name);
    }

    public boolean accept(String fnp, String fn) {
        fnp = ((String)fnp).replace('.', '#');
        fnp = ((String)fnp).replaceAll("#", "\\\\.");
        fnp = ((String)fnp).replace('*', '#');
        fnp = ((String)fnp).replaceAll("#", ".*");
        fnp = ((String)fnp).replace('?', '#');
        fnp = ((String)fnp).replaceAll("#", ".?");
        fnp = "^" + (String)fnp + "$";
        Pattern p = Pattern.compile((String)fnp);
        return p.matcher(fn).matches();
    }
}

