/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.secret;

import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public final class AwsSecretsManagerUtil {
    public static String loadSecretsFromAws(String region, String secretName) {
        SecretsManagerClientBuilder builder = SecretsManagerClient.builder();
        SecretsManagerClient secretsClient = (SecretsManagerClient)((SecretsManagerClientBuilder)SecretsManagerClient.builder().region(Region.of((String)region))).build();
        String secrets = AwsSecretsManagerUtil.getValue(secretsClient, secretName);
        secretsClient.close();
        return secrets;
    }

    private static String getValue(SecretsManagerClient secretsClient, String secretName) {
        GetSecretValueRequest valueRequest = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        GetSecretValueResponse valueResponse = secretsClient.getSecretValue(valueRequest);
        if (valueResponse == null) {
            return null;
        }
        return valueResponse.secretString();
    }
}

