/*
 * Decompiled with CFR 0.152.
 */
package bikframework.flexfilter;

import bikframework.flexfilter.QueryExecutor;
import bikframework.flexfilter.core.FieldIndexable;
import bikframework.flexfilter.core.QuerySpecificationBuilder;
import bikframework.flexfilter.core.QuerySqlParser;
import bikframework.flexfilter.model.AbstractQueryRequest;
import bikframework.flexfilter.model.ParameterizedQueryRequest;
import bikframework.flexfilter.model.QueryRequest;
import bikframework.flexfilter.model.QueryResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

public class JpaQueryExecutor<T>
implements QueryExecutor<T> {
    private final JpaSpecificationExecutor<T> repository;
    private final Class<T> entityClass;
    private final Set<String> allowedFields;
    private final Map<String, String> fieldNameMapping;

    public JpaQueryExecutor(JpaSpecificationExecutor<T> repository, Class<T> entityClass, Set<String> allowedFields, Map<String, String> fieldNameMapping) {
        this.repository = repository;
        this.entityClass = entityClass;
        this.allowedFields = new HashSet<String>(allowedFields);
        this.fieldNameMapping = fieldNameMapping;
        FieldIndexable.getFieldsWithSchema(entityClass).forEach(field -> this.allowedFields.add(field.getName()));
    }

    @Override
    public QueryResult<T> execute(QueryRequest request) throws Exception {
        Expression expr = QuerySqlParser.parse(request.getWhere());
        return this.doExecute(expr, request);
    }

    @Override
    public QueryResult<T> executeParameterized(ParameterizedQueryRequest request) throws Exception {
        Expression expr = QuerySqlParser.parse(request.getWhereTemplate());
        return this.doExecute(expr, request);
    }

    private QueryResult<T> doExecute(Expression expr, AbstractQueryRequest request) throws Exception {
        HashMap<String, Object> mapParameters = new HashMap<String, Object>();
        if (request instanceof ParameterizedQueryRequest) {
            ParameterizedQueryRequest parameterizedQueryRequest = (ParameterizedQueryRequest)request;
            parameterizedQueryRequest.getParameters().forEach((k, v) -> mapParameters.put(":" + k, v));
        }
        QuerySpecificationBuilder<T> builder = new QuerySpecificationBuilder<T>(this.entityClass, this.allowedFields, this.fieldNameMapping, mapParameters);
        Specification<T> spec = builder.build(expr);
        Sort orders = this.buildSort(request);
        Pageable pageable = this.buildPageable(request, orders);
        QueryResult queryResult = new QueryResult();
        if (pageable == null) {
            List all = orders == null ? this.repository.findAll(spec) : this.repository.findAll(spec, orders);
            queryResult.setResult(all);
        } else {
            Page jpaResult = this.repository.findAll(spec, pageable);
            if (jpaResult.hasContent()) {
                queryResult.setResult(jpaResult.getContent());
                queryResult.setTotalCount(jpaResult.getTotalElements());
                queryResult.setPageCount(jpaResult.getTotalPages());
            }
            queryResult.setPageRequest(true);
        }
        queryResult.setSorted(orders != null);
        queryResult.setCacheable(builder.isOnlyEqualExpression());
        return queryResult;
    }

    private Pageable buildPageable(AbstractQueryRequest request, Sort orders) {
        if (request.getPage() == Integer.MAX_VALUE || request.getSize() == Integer.MAX_VALUE) {
            return null;
        }
        int page = Math.max(request.getPage() - 1, 0);
        if (orders == null) {
            return PageRequest.of((int)page, (int)request.getSize());
        }
        return PageRequest.of((int)page, (int)request.getSize(), (Sort)orders);
    }

    private Sort buildSort(AbstractQueryRequest request) {
        if (request.getSort() == null || request.getSort().isEmpty()) {
            return null;
        }
        String[] sortParams = request.getSort().split(",");
        for (int i = 0; i < sortParams.length; ++i) {
            sortParams[i] = sortParams[i].trim();
        }
        Sort.Direction direction = request.isAscending() ? Sort.Direction.ASC : Sort.Direction.DESC;
        return Sort.by((Sort.Direction)direction, (String[])new String[]{sortParams[0]});
    }
}

