/*
 * Decompiled with CFR 0.152.
 */
package bikframework.flexfilter.core;

import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public final class FieldIndexable {
    public static final String OAS_X_BIK_FLEXFILTER = "x-bik-flexfilter";
    public static final String OAS_INDEXABLE = "indexable";

    public static List<Field> getFieldsWithSchema(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtils.doWithFields(clazz, field -> {
            if (AnnotationUtils.findAnnotation((AnnotatedElement)field, Schema.class) != null) {
                Schema annotation = field.getAnnotation(Schema.class);
                for (Extension extension : annotation.extensions()) {
                    if (!OAS_X_BIK_FLEXFILTER.equalsIgnoreCase(extension.name()) || !FieldIndexable.hasIndexable(extension)) continue;
                    result.add(field);
                    break;
                }
            }
        });
        return result;
    }

    private static boolean hasIndexable(Extension extension) {
        for (ExtensionProperty p : extension.properties()) {
            if (!OAS_INDEXABLE.equalsIgnoreCase(p.name()) || !"true".equalsIgnoreCase(p.value())) continue;
            return true;
        }
        return false;
    }
}

