/*
 * Decompiled with CFR 0.152.
 */
package bikframework.flexfilter.core;

import bikframework.flexfilter.core.QuerySqlParser;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import org.springframework.data.jpa.domain.Specification;

public class QuerySpecificationBuilder<T> {
    private boolean onlyEqualExpression = true;
    private final Class<T> entityClass;
    private final Set<String> allowedFields;
    private final Map<String, String> fieldNameMapping;
    private final Map<String, Object> paramMapping;

    public QuerySpecificationBuilder(Class<T> entityClass, Set<String> allowedFields, Map<String, String> fieldNameMapping, Map<String, Object> paramMapping) {
        this.entityClass = entityClass;
        this.allowedFields = allowedFields;
        this.fieldNameMapping = fieldNameMapping;
        this.paramMapping = paramMapping;
    }

    public Specification<T> build(Expression expr) throws Exception {
        return this.parseExpression(expr);
    }

    public Specification<T> build(String whereClause) throws Exception {
        return this.build(QuerySqlParser.parse(whereClause));
    }

    public boolean isOnlyEqualExpression() {
        return this.onlyEqualExpression;
    }

    private boolean checkEqualExpr(Expression expr) {
        if (expr instanceof ExpressionList) {
            ExpressionList exprList = (ExpressionList)expr;
            return this.checkEqualExpr((Expression)exprList.getFirst());
        }
        if (expr instanceof AndExpression) {
            AndExpression andExpr = (AndExpression)expr;
            return this.checkEqualExpr(andExpr.getLeftExpression()) && this.checkEqualExpr(andExpr.getRightExpression());
        }
        if (expr instanceof OrExpression) {
            OrExpression orExpr = (OrExpression)expr;
            return this.checkEqualExpr(orExpr.getLeftExpression()) && this.checkEqualExpr(orExpr.getRightExpression());
        }
        return expr instanceof EqualsTo;
    }

    private Specification<T> parseExpression(Expression expr) throws Exception {
        if (expr instanceof ExpressionList) {
            ExpressionList exprList = (ExpressionList)expr;
            return this.parseExpression((Expression)exprList.getFirst());
        }
        if (expr instanceof AndExpression) {
            AndExpression andExpr = (AndExpression)expr;
            return this.parseExpression(andExpr.getLeftExpression()).and(this.parseExpression(andExpr.getRightExpression()));
        }
        if (expr instanceof OrExpression) {
            OrExpression orExpr = (OrExpression)expr;
            return this.parseExpression(orExpr.getLeftExpression()).or(this.parseExpression(orExpr.getRightExpression()));
        }
        if (expr instanceof EqualsTo) {
            EqualsTo eqExpr = (EqualsTo)expr;
            return this.simpleComparison(eqExpr.getLeftExpression(), eqExpr.getRightExpression(), "=");
        }
        this.onlyEqualExpression = false;
        if (expr instanceof NotEqualsTo) {
            NotEqualsTo neExpr = (NotEqualsTo)expr;
            return this.simpleComparison(neExpr.getLeftExpression(), neExpr.getRightExpression(), "!=");
        }
        if (expr instanceof GreaterThan) {
            GreaterThan gtExpr = (GreaterThan)expr;
            return this.simpleComparison(gtExpr.getLeftExpression(), gtExpr.getRightExpression(), ">");
        }
        if (expr instanceof GreaterThanEquals) {
            GreaterThanEquals gteExpr = (GreaterThanEquals)expr;
            return this.simpleComparison(gteExpr.getLeftExpression(), gteExpr.getRightExpression(), ">=");
        }
        if (expr instanceof MinorThan) {
            MinorThan ltExpr = (MinorThan)expr;
            return this.simpleComparison(ltExpr.getLeftExpression(), ltExpr.getRightExpression(), "<");
        }
        if (expr instanceof MinorThanEquals) {
            MinorThanEquals lteExpr = (MinorThanEquals)expr;
            return this.simpleComparison(lteExpr.getLeftExpression(), lteExpr.getRightExpression(), "<=");
        }
        if (expr instanceof InExpression) {
            InExpression inExpr = (InExpression)expr;
            return this.inExpression(inExpr);
        }
        if (expr instanceof Between) {
            Between betweenExpr = (Between)expr;
            return this.betweenExpression(betweenExpr);
        }
        if (expr instanceof IsNullExpression) {
            IsNullExpression isNullExpr = (IsNullExpression)expr;
            return this.isNullExpression(isNullExpr);
        }
        if (expr instanceof NotExpression) {
            NotExpression notExpr = (NotExpression)expr;
            return this.notExpression(notExpr);
        }
        throw new UnsupportedOperationException("Unsupported expression: " + String.valueOf(expr));
    }

    private Specification<T> simpleComparison(Expression left, Expression right, String op) {
        String field = this.validateField(left.toString());
        String valueStr = this.replaceParameter(right.toString());
        return (Specification & Serializable)(root, query, cb) -> {
            Path path = root.get(field);
            jakarta.persistence.criteria.Expression expression = this.castField((Path<Object>)path);
            Comparable value = this.castValue(path.getJavaType(), valueStr);
            return switch (op) {
                case "=" -> cb.equal((jakarta.persistence.criteria.Expression)path, (Object)value);
                case "!=" -> cb.notEqual((jakarta.persistence.criteria.Expression)path, (Object)value);
                case ">" -> cb.greaterThan(expression, value);
                case ">=" -> cb.greaterThanOrEqualTo(expression, value);
                case "<" -> cb.lessThan(expression, value);
                case "<=" -> cb.lessThanOrEqualTo(expression, value);
                default -> throw new UnsupportedOperationException("Unsupported operator: " + op);
            };
        };
    }

    private Specification<T> inExpression(InExpression expr) {
        String field = this.validateField(expr.getLeftExpression().toString());
        Expression right = expr.getRightExpression();
        if (right instanceof ExpressionList) {
            ExpressionList exprList = (ExpressionList)right;
            return (Specification & Serializable)(root, query, cb) -> {
                ArrayList values = new ArrayList();
                List list = exprList.getExpressions();
                for (Expression valExpr : list) {
                    List<String> valueList = this.replaceParameter2(valExpr.toString());
                    valueList.forEach(valueStr -> {
                        Comparable value = this.castValue(root.get(field).getJavaType(), (String)valueStr);
                        values.add(value);
                    });
                }
                return expr.isNot() ? cb.not((jakarta.persistence.criteria.Expression)root.get(field).in(values)) : root.get(field).in(values);
            };
        }
        throw new UnsupportedOperationException("Unsupported IN expression");
    }

    private Specification<T> betweenExpression(Between expr) {
        String field = this.validateField(expr.getLeftExpression().toString());
        String startValueStr = this.replaceParameter(expr.getBetweenExpressionStart().toString());
        String endValueStr = this.replaceParameter(expr.getBetweenExpressionEnd().toString());
        return (Specification & Serializable)(root, query, cb) -> {
            Path path = root.get(field);
            jakarta.persistence.criteria.Expression expression = this.castField((Path<Object>)path);
            Comparable startValue = this.castValue(path.getJavaType(), startValueStr);
            Comparable endValue = this.castValue(path.getJavaType(), endValueStr);
            Predicate betweenPredicate = cb.between(expression, startValue, endValue);
            return expr.isNot() ? cb.not((jakarta.persistence.criteria.Expression)betweenPredicate) : betweenPredicate;
        };
    }

    private Specification<T> isNullExpression(IsNullExpression expr) {
        String field = this.validateField(expr.getLeftExpression().toString());
        return (Specification & Serializable)(root, query, cb) -> {
            Path path = root.get(field);
            return expr.isNot() ? cb.isNotNull((jakarta.persistence.criteria.Expression)path) : cb.isNull((jakarta.persistence.criteria.Expression)path);
        };
    }

    private Specification<T> notExpression(NotExpression expr) throws Exception {
        Expression innerExpr = expr.getExpression();
        Specification innerSpec = this.parseExpression(innerExpr);
        return (Specification & Serializable)(root, query, cb) -> cb.not((jakarta.persistence.criteria.Expression)innerSpec.toPredicate(root, query, cb));
    }

    private String validateField(String field) {
        if (!this.allowedFields.contains(field)) {
            throw new SecurityException("Field not allowed: " + field);
        }
        if (this.fieldNameMapping != null) {
            return this.fieldNameMapping.getOrDefault(field, field);
        }
        return field;
    }

    private jakarta.persistence.criteria.Expression castField(Path<Object> path) {
        Class fieldType = path.getJavaType();
        if (fieldType == Integer.class) {
            return path.as(Integer.class);
        }
        if (fieldType == Long.class) {
            return path.as(Long.class);
        }
        if (fieldType == Boolean.class) {
            return path.as(Boolean.class);
        }
        if (fieldType == String.class) {
            return path.as(String.class);
        }
        if (fieldType == LocalDate.class) {
            return path.as(LocalDate.class);
        }
        throw new RuntimeException("Unsupported type for greaterThan: " + String.valueOf(fieldType));
    }

    private Comparable castValue(Class<?> targetType, String valueStr) {
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.valueOf(valueStr);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.valueOf(valueStr);
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.valueOf(valueStr);
        }
        return valueStr;
    }

    private String replaceParameter(String valueStr) {
        Object o;
        if (!this.paramMapping.isEmpty() && (o = this.paramMapping.get(valueStr)) != null) {
            if (o instanceof Number || o instanceof Boolean) {
                return o.toString();
            }
            return o.toString().replaceAll("'", "");
        }
        return valueStr.replaceAll("'", "");
    }

    private List<String> replaceParameter2(String valueStr) {
        Object o;
        if (!this.paramMapping.isEmpty() && (o = this.paramMapping.get(valueStr)) != null) {
            if (o instanceof Number || o instanceof Boolean) {
                return Collections.singletonList(o.toString());
            }
            if (o instanceof List) {
                List ol = (List)o;
                return ol.stream().map(v -> v.toString().replaceAll("'", "")).collect(Collectors.toList());
            }
            return Collections.singletonList(o.toString().replaceAll("'", ""));
        }
        return Collections.singletonList(valueStr.replaceAll("'", ""));
    }
}

