/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.request;

import bikframework.log.request.RequestLogAspect;
import bikframework.log.request.RequestLogFilter;
import bikframework.log.request.RequestLogProperties;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Filter.class})
@ConditionalOnProperty(prefix="bikframework.log.request", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={RequestLogProperties.class})
public class RequestLogAutoConfiguration {
    private final RequestLogProperties logProperties;

    @Bean
    public FilterRegistrationBean<RequestLogFilter> requestLogFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new RequestLogFilter());
        registrationBean.addInitParameter("NEED_RESULT", String.valueOf(this.logProperties.isNeedParam()));
        registrationBean.addInitParameter("NEED_PARAM", String.valueOf(this.logProperties.isNeedParam()));
        registrationBean.addInitParameter("MAX_RESULT_LENGTH", String.valueOf(this.logProperties.getMaxResultLength()));
        registrationBean.addInitParameter("MAX_BODY_LENGTH", String.valueOf(this.logProperties.getMaxBodyLength()));
        registrationBean.addInitParameter("EXCLUDE_PATTERNS", this.logProperties.getExcludePatterns());
        registrationBean.addInitParameter("EXCLUDE_METHODS", this.logProperties.getExcludeMethods());
        registrationBean.addInitParameter("EXCLUDE_HEADERS", this.logProperties.getExcludeHeaders());
        registrationBean.addInitParameter("INCLUDE_HEADERS", this.logProperties.getIncludeHeaders());
        registrationBean.addInitParameter("DESENSITIZATION_HEADERS", this.logProperties.getDesensitizationHeaders());
        registrationBean.addInitParameter("DESENSITIZATION_CONTENT_URI_PATTERNS", this.logProperties.getDesensitizationContentUriPatterns());
        registrationBean.addInitParameter("RECORD_TYPE", this.logProperties.getRecordType());
        registrationBean.addUrlPatterns(this.logProperties.getUrlPatterns());
        registrationBean.setOrder(this.logProperties.getOrder());
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestLogAspect requestLogAspect() {
        return new RequestLogAspect();
    }

    @Generated
    public RequestLogAutoConfiguration(RequestLogProperties logProperties) {
        this.logProperties = logProperties;
    }
}

