/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.trace;

import bikframework.log.trace.TraceProperties;
import bikframework.log.trace.core.TraceClientInterceptor;
import bikframework.log.trace.core.TraceFilter;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="bikframework.trace", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={TraceProperties.class})
public class TraceAutoConfiguration {
    private final TraceProperties traceProperties;

    @Generated
    public TraceAutoConfiguration(TraceProperties traceProperties) {
        this.traceProperties = traceProperties;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RestClient.class})
    public static class TraceFeignConfiguration {
        @Bean
        public TraceClientInterceptor traceRequestInterceptor() {
            return new TraceClientInterceptor();
        }
    }

    @Configuration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={Filter.class})
    public class TraceFilterConfiguration {
        @Bean
        public FilterRegistrationBean<TraceFilter> bkTraceFilter() {
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter((Filter)new TraceFilter());
            registrationBean.addUrlPatterns(TraceAutoConfiguration.this.traceProperties.getFilterUrls());
            registrationBean.setOrder(-2147483647);
            return registrationBean;
        }
    }
}

