/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.trace.core;

import bikframework.log.trace.TraceBean;
import bikframework.log.trace.TraceContext;
import bikframework.utils.uuid.UniqueIdGenerator;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.web.filter.GenericFilterBean;

public class TraceFilter
extends GenericFilterBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (request instanceof HttpServletRequest) {
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String traceId = httpRequest.getHeader("eTraceId");
                if (StringUtils.isBlank((CharSequence)traceId)) {
                    traceId = UniqueIdGenerator.INSTANCE.getUniqueIdString();
                }
                TraceContext.putTraceId(traceId);
                String parentSpanId = httpRequest.getHeader("eSpanId");
                if (StringUtils.isNotBlank((CharSequence)parentSpanId)) {
                    TraceContext.putParentSpanId(parentSpanId);
                }
                TraceContext.putSpanId(UniqueIdGenerator.INSTANCE.getUniqueIdString());
                TraceBean traceBean = TraceContext.getBean();
                if (null != traceBean) {
                    MDC.put((String)"trace.traceId", (String)traceBean.getTraceId());
                    MDC.put((String)"trace.spanId", (String)traceBean.getSpanId());
                    MDC.put((String)"trace.parentSpanId", (String)traceBean.getParentSpanId());
                }
                chain.doFilter(request, response);
            }
            finally {
                MDC.remove((String)"eTraceId");
                TraceContext.clean();
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

