/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private static final DateTimeFormatter FORMATTER_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER_SECOND = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final int DAY_MILLS = 86400000;

    public static String formatTime(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return FORMATTER_MILLIS.format(localDateTime);
    }

    public static String formatTime(long timestamp, ZoneId zoneId) {
        return FORMATTER_MILLIS.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId == null ? ZoneId.systemDefault() : zoneId));
    }

    public static String formatTime2(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(localDateTime);
    }

    public static String formatTime(long timestamp, String timeZoneId, String pattern) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        ZoneId zoneId = ZoneId.of(timeZoneId);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, Locale.US);
        return localDateTime.format(formatter);
    }

    public static long getStartOfDayTimestamp() {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate currentDate = LocalDate.now();
        ZonedDateTime startOfDay = currentDate.atStartOfDay(zoneId);
        return startOfDay.toInstant().toEpochMilli();
    }

    public static long getDayStamp(long millTimestamp) {
        return millTimestamp / 86400000L;
    }

    public static long getTimeStampSecond(String dateStr) {
        try {
            return LocalDateTime.parse(dateStr, FORMATTER_SECOND).atZone(ZoneId.systemDefault()).toEpochSecond();
        }
        catch (Exception e) {
            log.error("Cannot get time stamp string, the invalid date format is yyyy-MM-dd HH:mm:ss, please check!");
            return 1577808000L;
        }
    }

    public static void sleep(int mills) {
        try {
            Thread.sleep(mills);
        }
        catch (InterruptedException e) {
            log.error("Sleep error ", (Throwable)e);
        }
    }

    @Generated
    private DateUtils() {
    }
}

