/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils;

import bikframework.utils.encrypt.AESUtils;
import com.google.common.base.Strings;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentUtil
implements ApplicationContextAware {
    private static Environment environment;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        environment = applicationContext.getEnvironment();
    }

    public static String getString(String key) {
        return environment.getProperty(key);
    }

    public static String getString(String key, String defaultValue) {
        return environment.getProperty(key, defaultValue);
    }

    public static String getAESString(String key, String aeskey, String defaultValue) {
        String v = EnvironmentUtil.getAESString(key, aeskey);
        if (Strings.isNullOrEmpty((String)v)) {
            return defaultValue;
        }
        return v;
    }

    public static String getAESString(String key, String aeskey) {
        String original = EnvironmentUtil.getString(key);
        if (Strings.isNullOrEmpty((String)original)) {
            return "";
        }
        try {
            return AESUtils.decrypt(original, aeskey);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Integer getInt(String key) {
        return EnvironmentUtil.getProperty(key, Integer.class);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        return EnvironmentUtil.getProperty(key, Integer.class, defaultValue);
    }

    public static Long getLong(String key) {
        return EnvironmentUtil.getProperty(key, Long.class);
    }

    public static Long getLong(String key, Long defaultValue) {
        return EnvironmentUtil.getProperty(key, Long.class, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return EnvironmentUtil.getProperty(key, Boolean.class);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return EnvironmentUtil.getProperty(key, Boolean.class, defaultValue);
    }

    public static <T> T getProperty(String key, Class<T> targetType) {
        return (T)environment.getProperty(key, targetType);
    }

    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)environment.getProperty(key, targetType, defaultValue);
    }
}

