/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils;

import bikframework.log.model.HttpServletRequestCopier;
import bikframework.utils.EnvironmentUtil;
import bikframework.web.domain.ApiBaseRemote;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final org.apache.logging.log4j.Logger logger = LogManager.getLogger(HttpUtils.class);
    private static ImmutableList<String> ipHeaderNameList = ImmutableList.builder().add((Object)"x-forwarded-for").add((Object)"CF-Connecting-IP").add((Object)"Proxy-Client-IP").add((Object)"WL-Proxy-Client-IP").add((Object)"X-Forwarded-For").add((Object)"HTTP_X_REAL_IP").add((Object)"HTTP_CLIENT_IP").add((Object)"HTTP_X_FORWARDED_FOR").build();

    public static String getRealRemoteIp(HttpServletRequest request) {
        if (EnvironmentUtil.getBoolean("client.ip.new.switch", true).booleanValue()) {
            return HttpUtils.getNewRealRemoteIp(request, "");
        }
        String paramIpAddress = request.getRemoteAddr();
        String headerResult = "";
        if (request.getHeader("CF-Connecting-IP") != null) {
            paramIpAddress = request.getHeader("CF-Connecting-IP");
            headerResult = "CF-Connecting-IP";
        } else if (request.getHeader("X-Forwarded-For") != null) {
            paramIpAddress = request.getHeader("X-Forwarded-For");
            headerResult = "X-Forwarded-For";
        } else if (request.getHeader("HTTP_X_REAL_IP") != null) {
            paramIpAddress = request.getHeader("HTTP_X_REAL_IP");
            headerResult = "HTTP_X_REAL_IP";
        } else if (request.getHeader("HTTP_CLIENT_IP") != null) {
            paramIpAddress = request.getHeader("HTTP_CLIENT_IP");
            headerResult = "HTTP_CLIENT_IP";
        } else if (request.getHeader("HTTP_X_FORWARDED_FOR") != null) {
            paramIpAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
            headerResult = "HTTP_X_FORWARDED_FOR";
        }
        if (EnvironmentUtil.getBoolean("account.show.ip.detail.switch", false).booleanValue()) {
            logger.info("get real remote ip ,chose {} success, paramIpAddress:{}", (Object)headerResult, (Object)paramIpAddress);
        }
        return HttpUtils.getRealClientIp(paramIpAddress);
    }

    public static String getRealRemoteIp(HttpServletRequest request, String mac) {
        if (EnvironmentUtil.getBoolean("client.ip.new.switch", false).booleanValue()) {
            return HttpUtils.getNewRealRemoteIp(request, mac);
        }
        String paramIpAddress = request.getRemoteAddr();
        String headerResult = "";
        if (request.getHeader("CF-Connecting-IP") != null) {
            paramIpAddress = request.getHeader("CF-Connecting-IP");
            headerResult = "CF-Connecting-IP";
        } else if (request.getHeader("X-Forwarded-For") != null) {
            paramIpAddress = request.getHeader("X-Forwarded-For");
            headerResult = "X-Forwarded-For";
        } else if (request.getHeader("HTTP_X_REAL_IP") != null) {
            paramIpAddress = request.getHeader("HTTP_X_REAL_IP");
            headerResult = "HTTP_X_REAL_IP";
        } else if (request.getHeader("HTTP_CLIENT_IP") != null) {
            paramIpAddress = request.getHeader("HTTP_CLIENT_IP");
            headerResult = "HTTP_CLIENT_IP";
        } else if (request.getHeader("HTTP_X_FORWARDED_FOR") != null) {
            paramIpAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
            headerResult = "HTTP_X_FORWARDED_FOR";
        }
        if (EnvironmentUtil.getBoolean("account.show.ip.detail.switch", false).booleanValue()) {
            logger.info("get real remote ip ,chose {} success, paramIpAddress:{}, mac:{}", (Object)headerResult, (Object)paramIpAddress, (Object)mac);
        }
        return HttpUtils.getRealClientIp(paramIpAddress);
    }

    private static String getRealClientIp(String paramIpAddress) {
        if (Strings.isNullOrEmpty((String)paramIpAddress)) {
            return "";
        }
        int commaPos = paramIpAddress.indexOf(44);
        if (commaPos > 0) {
            paramIpAddress = paramIpAddress.substring(0, commaPos);
        }
        return Strings.nullToEmpty((String)paramIpAddress).trim();
    }

    public static String getRemoteRegion(HttpServletRequest request) {
        return Strings.nullToEmpty((String)request.getHeader("CF-IPCountry"));
    }

    public static void updateRemoteInfo(ApiBaseRemote apiBaseRemote, HttpServletRequest request) {
        apiBaseRemote.setProxyIp(request.getRemoteAddr());
        apiBaseRemote.setClientIp(HttpUtils.getRealRemoteIp(request));
        apiBaseRemote.setClientRegion(HttpUtils.getRemoteRegion(request));
    }

    public static void updateRemoteInfo(ApiBaseRemote apiBaseRemote, HttpServletRequest request, String mac) {
        apiBaseRemote.setProxyIp(request.getRemoteAddr());
        apiBaseRemote.setClientIp(HttpUtils.getRealRemoteIp(request, mac));
        apiBaseRemote.setClientRegion(HttpUtils.getRemoteRegion(request));
    }

    private static String getNewRealRemoteIp(HttpServletRequest request, String mac) {
        String paramIpAddress = request.getRemoteAddr();
        String headerResult = "";
        if (request.getHeader("X-Forwarded-For") != null) {
            paramIpAddress = request.getHeader("X-Forwarded-For");
            headerResult = "X-Forwarded-For";
        } else if (request.getHeader("CF-Connecting-IP") != null) {
            paramIpAddress = request.getHeader("CF-Connecting-IP");
            headerResult = "CF-Connecting-IP";
        } else if (request.getHeader("HTTP_X_REAL_IP") != null) {
            paramIpAddress = request.getHeader("HTTP_X_REAL_IP");
            headerResult = "HTTP_X_REAL_IP";
        } else if (request.getHeader("HTTP_CLIENT_IP") != null) {
            paramIpAddress = request.getHeader("HTTP_CLIENT_IP");
            headerResult = "HTTP_CLIENT_IP";
        } else if (request.getHeader("HTTP_X_FORWARDED_FOR") != null) {
            paramIpAddress = request.getHeader("HTTP_X_FORWARDED_FOR");
            headerResult = "HTTP_X_FORWARDED_FOR";
        }
        if (EnvironmentUtil.getBoolean("account.show.ip.detail.switch", false).booleanValue()) {
            logger.info("get new real remote ip ,chose {} success, paramIpAddress:{}, mac:{}", (Object)headerResult, (Object)paramIpAddress, (Object)mac);
        }
        return HttpUtils.getRealClientIp(paramIpAddress);
    }

    public static String getApiPath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public static String getRequestBody(HttpServletRequestCopier requestCopier, boolean showDetail) {
        try {
            if (null != requestCopier.getContentType() && requestCopier.getContentType().contains("multipart/form-data")) {
                if (showDetail) {
                    return "multipart/form-data, contentLength is: " + requestCopier.getContentLength();
                }
                return "";
            }
            ServletInputStream servletInputStream = requestCopier.getInputStream();
            byte[] bytes = requestCopier.getCopy();
            if (null == bytes || bytes.length == 0) {
                bytes = servletInputStream.isFinished() ? requestCopier.getCopy() : HttpUtils.convertInputStreamToBytes((InputStream)servletInputStream);
            }
            bytes = null == bytes ? new byte[]{} : bytes;
            String charset = requestCopier.getCharacterEncoding();
            if (null != charset) {
                return new String(bytes, charset);
            }
            return new String(bytes);
        }
        catch (Exception ex) {
            log.warn("\u83b7\u53d6http\u8bf7\u6c42body", (Throwable)ex);
            return "";
        }
    }

    private static byte[] convertInputStreamToBytes(InputStream input) {
        ByteArrayOutputStream output;
        block3: {
            output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            try {
                int n;
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block3;
                log.info("convertInputStreamToBytes failed.", (Throwable)e);
            }
        }
        return output.toByteArray();
    }

    public static String getRequestURI(HttpServletRequest request) {
        String apiName = request.getRequestURI();
        apiName = apiName.substring(1).replace("/", "_");
        return apiName;
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String headerName;
        String remoteHost = null;
        UnmodifiableIterator unmodifiableIterator = ipHeaderNameList.iterator();
        while (unmodifiableIterator.hasNext() && !HttpUtils.isInvalidClientIp(remoteHost = request.getHeader(headerName = (String)unmodifiableIterator.next()))) {
        }
        if (!HttpUtils.isInvalidClientIp(remoteHost)) {
            remoteHost = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(remoteHost) && remoteHost.length() > 15 && remoteHost.indexOf(",") > 0) {
            remoteHost = remoteHost.substring(0, remoteHost.indexOf(","));
        }
        return Strings.nullToEmpty((String)remoteHost);
    }

    public static Long getLongParameter(HttpServletRequest request, String key) {
        String v = HttpUtils.getHttpParameter(request, key);
        if (Strings.isNullOrEmpty((String)v)) {
            return null;
        }
        return Long.valueOf(v);
    }

    public static String getHttpParameter(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return "";
        }
        return request.getParameter(key);
    }

    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty((String)clientIp)) {
            return false;
        }
        return !"unknown".equalsIgnoreCase(clientIp);
    }
}

