/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils;

import bikframework.web.domain.EAppApiErrCode;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import io.jsonwebtoken.security.SignatureAlgorithm;
import java.io.IOException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenUtil.class);
    private static final KeyPair KEY_PAIR = (KeyPair)Jwts.SIG.RS256.keyPair().build();
    private static final SignatureAlgorithm ALGORITHM = Jwts.SIG.RS256;

    public static Map<String, String> generateKeyPair() throws IOException {
        final String publicKeyStr = Base64.getEncoder().encodeToString(KEY_PAIR.getPublic().getEncoded());
        final String privateKeyStr = Base64.getEncoder().encodeToString(KEY_PAIR.getPrivate().getEncoded());
        return new HashMap<String, String>(){
            {
                this.put("publicKey", publicKeyStr);
                this.put("privateKey", privateKeyStr);
            }
        };
    }

    public static PublicKey getPublicKey(String publicKeyStr) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] publicBytes = Base64.getDecoder().decode(publicKeyStr);
        return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicBytes));
    }

    public static PrivateKey getPrivateKey(String privateKeyStr) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privateBytes = Base64.getDecoder().decode(privateKeyStr);
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateBytes));
    }

    @Deprecated
    public static String generateToken(String subject, long expirationMillis, SignatureAlgorithm signatureAlgorithm, PrivateKey privateKey, Map<String, ?> claims) {
        return ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().keyId("aKeyId")).and()).subject(subject).claims(claims).expiration(new Date(System.currentTimeMillis() + expirationMillis)).signWith((Key)privateKey, (SecureDigestAlgorithm)signatureAlgorithm).compact();
    }

    public static String generateToken(String subject, long expirationMillis, PrivateKey privateKey, Map<String, ?> claims) {
        return JwtTokenUtil.generateToken(subject, expirationMillis, ALGORITHM, privateKey, claims);
    }

    public static Map<String, Object> getAllClaimsFromToken(String token, PublicKey publicKey) {
        return (Map)Jwts.parser().verifyWith(publicKey).build().parseSignedClaims((CharSequence)token).getPayload();
    }

    public static TokenValidationResult validateToken(String token, PublicKey publicKey) {
        try {
            Jwts.parser().verifyWith(publicKey).build().parse((CharSequence)token);
            return new TokenValidationResult(true, null, 0);
        }
        catch (MalformedJwtException e) {
            logger.info("Invalid JWT token: {}", (Object)e.getMessage());
            return new TokenValidationResult(false, "Invalid JWT token", EAppApiErrCode.TOKEN_INVALID.getCode());
        }
        catch (ExpiredJwtException e) {
            logger.info("JWT token is expired: {}", (Object)e.getMessage());
            return new TokenValidationResult(false, "JWT token is expired", EAppApiErrCode.TOKEN_EXPIRED.getCode());
        }
        catch (UnsupportedJwtException e) {
            logger.info("JWT token is unsupported: {}", (Object)e.getMessage());
            return new TokenValidationResult(false, "JWT token is unsupported", EAppApiErrCode.TOKEN_NOT_SUPPORTED.getCode());
        }
        catch (IllegalArgumentException e) {
            logger.info("JWT claims string is empty: {}", (Object)e.getMessage());
            return new TokenValidationResult(false, "JWT claims string is empty", EAppApiErrCode.TOKEN_CLAIM_EMPTY.getCode());
        }
        catch (Exception e) {
            logger.info("JWT validation failed: {}", (Object)e.getMessage());
            return new TokenValidationResult(false, "JWT validation failed", EAppApiErrCode.TOKEN_FAIL.getCode());
        }
    }

    public static class TokenValidationResult {
        private final boolean valid;
        private final String errorMessage;
        private final int code;

        public TokenValidationResult(boolean valid, String errorMessage, int code) {
            this.valid = valid;
            this.errorMessage = errorMessage;
            this.code = code;
        }

        public boolean isValid() {
            return this.valid;
        }

        public int getCode() {
            return this.code;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

