/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class ValidatorUtils {
    private ValidatorUtils() {
        throw new AssertionError((Object)(this.getClass().getName() + "not can be instances for you!"));
    }

    public static boolean isNullOrEmpty(Object value) {
        if (null == value) {
            return true;
        }
        if (value instanceof CharSequence) {
            return StringUtils.isBlank((CharSequence)((CharSequence)value));
        }
        if (ValidatorUtils.isCollectionsSupportType(value)) {
            return CollectionUtils.sizeIsEmpty((Object)value);
        }
        return false;
    }

    public static boolean isNotNullOrEmpty(Object value) {
        return !ValidatorUtils.isNullOrEmpty(value);
    }

    private static boolean isCollectionsSupportType(Object value) {
        boolean isCollectionOrMap = value instanceof Collection || value instanceof Map;
        boolean isEnumerationOrIterator = value instanceof Enumeration || value instanceof Iterator;
        return isCollectionOrMap || isEnumerationOrIterator || value.getClass().isArray();
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean notEquals(Object a, Object b) {
        return !ValidatorUtils.equals(a, b);
    }
}

