/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.consistenthash;

import bikframework.utils.consistenthash.IHashFunction;
import bikframework.utils.consistenthash.INodeObject;
import bikframework.utils.consistenthash.hashing.NativeHash;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash<T extends INodeObject> {
    private final int virtualNodeCount;
    private final IHashFunction hashFunction;
    private final SortedMap<Long, T> circle = new TreeMap<Long, T>();
    public static final int VIRTUAL_NODE_COUNT = 160;

    public ConsistentHash(Collection<T> nodes, int virtualNodeCount, IHashFunction hashFunction) {
        this.virtualNodeCount = virtualNodeCount;
        this.hashFunction = hashFunction;
        nodes.forEach(e -> this.add(e));
    }

    public ConsistentHash(Collection<T> nodes, int virtualNodeCount) {
        this(nodes, virtualNodeCount, new NativeHash());
    }

    public ConsistentHash(Collection<T> nodes) {
        this(nodes, 160, new NativeHash());
    }

    public void add(T node) {
        if (Objects.nonNull(node)) {
            for (int i = 0; i < this.virtualNodeCount; ++i) {
                this.circle.put(this.hashFunction.hash(this.buildVirtualNodeKey(node.getKey(), i)), node);
            }
        }
    }

    public void remove(T node) {
        if (Objects.nonNull(node)) {
            for (int i = 0; i < this.virtualNodeCount; ++i) {
                this.circle.remove(this.hashFunction.hash(this.buildVirtualNodeKey(node.getKey(), i)));
            }
        }
    }

    public T get(String key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        long hash = this.hashFunction.hash(key);
        INodeObject node = (INodeObject)this.circle.get(hash);
        if (Objects.nonNull(node)) {
            return (T)node;
        }
        SortedMap<Long, T> tailMap = this.circle.tailMap(hash);
        hash = tailMap.isEmpty() ? this.circle.firstKey() : tailMap.firstKey();
        node = (INodeObject)this.circle.get(hash);
        return (T)node;
    }

    private String buildVirtualNodeKey(String key, int index) {
        return String.format("%s.%d", key, index);
    }
}

