/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.encrypt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AESCryptor {
    private static final Logger logger = LoggerFactory.getLogger(AESCryptor.class);
    public static final int KEY_SIZE = 16;
    private static final char[] CRC_TB = new char[]{'\u0000', '\u1021', '\u2042', '\u3063', '\u4084', '\u50a5', '\u60c6', '\u70e7', '\u8108', '\u9129', '\ua14a', '\ub16b', '\uc18c', '\ud1ad', '\ue1ce', '\uf1ef', '\u1231', '\u0210', '\u3273', '\u2252', '\u52b5', '\u4294', '\u72f7', '\u62d6', '\u9339', '\u8318', '\ub37b', '\ua35a', '\ud3bd', '\uc39c', '\uf3ff', '\ue3de', '\u2462', '\u3443', '\u0420', '\u1401', '\u64e6', '\u74c7', '\u44a4', '\u5485', '\ua56a', '\ub54b', '\u8528', '\u9509', '\ue5ee', '\uf5cf', '\uc5ac', '\ud58d', '\u3653', '\u2672', '\u1611', '\u0630', '\u76d7', '\u66f6', '\u5695', '\u46b4', '\ub75b', '\ua77a', '\u9719', '\u8738', '\uf7df', '\ue7fe', '\ud79d', '\uc7bc', '\u48c4', '\u58e5', '\u6886', '\u78a7', '\u0840', '\u1861', '\u2802', '\u3823', '\uc9cc', '\ud9ed', '\ue98e', '\uf9af', '\u8948', '\u9969', '\ua90a', '\ub92b', '\u5af5', '\u4ad4', '\u7ab7', '\u6a96', '\u1a71', '\u0a50', '\u3a33', '\u2a12', '\udbfd', '\ucbdc', '\ufbbf', '\ueb9e', '\u9b79', '\u8b58', '\ubb3b', '\uab1a', '\u6ca6', '\u7c87', '\u4ce4', '\u5cc5', '\u2c22', '\u3c03', '\u0c60', '\u1c41', '\uedae', '\ufd8f', '\ucdec', '\uddcd', '\uad2a', '\ubd0b', '\u8d68', '\u9d49', '\u7e97', '\u6eb6', '\u5ed5', '\u4ef4', '\u3e13', '\u2e32', '\u1e51', '\u0e70', '\uff9f', '\uefbe', '\udfdd', '\ucffc', '\ubf1b', '\uaf3a', '\u9f59', '\u8f78', '\u9188', '\u81a9', '\ub1ca', '\ua1eb', '\ud10c', '\uc12d', '\uf14e', '\ue16f', '\u1080', '\u00a1', '\u30c2', '\u20e3', '\u5004', '\u4025', '\u7046', '\u6067', '\u83b9', '\u9398', '\ua3fb', '\ub3da', '\uc33d', '\ud31c', '\ue37f', '\uf35e', '\u02b1', '\u1290', '\u22f3', '\u32d2', '\u4235', '\u5214', '\u6277', '\u7256', '\ub5ea', '\ua5cb', '\u95a8', '\u8589', '\uf56e', '\ue54f', '\ud52c', '\uc50d', '\u34e2', '\u24c3', '\u14a0', '\u0481', '\u7466', '\u6447', '\u5424', '\u4405', '\ua7db', '\ub7fa', '\u8799', '\u97b8', '\ue75f', '\uf77e', '\uc71d', '\ud73c', '\u26d3', '\u36f2', '\u0691', '\u16b0', '\u6657', '\u7676', '\u4615', '\u5634', '\ud94c', '\uc96d', '\uf90e', '\ue92f', '\u99c8', '\u89e9', '\ub98a', '\ua9ab', '\u5844', '\u4865', '\u7806', '\u6827', '\u18c0', '\u08e1', '\u3882', '\u28a3', '\ucb7d', '\udb5c', '\ueb3f', '\ufb1e', '\u8bf9', '\u9bd8', '\uabbb', '\ubb9a', '\u4a75', '\u5a54', '\u6a37', '\u7a16', '\u0af1', '\u1ad0', '\u2ab3', '\u3a92', '\ufd2e', '\ued0f', '\udd6c', '\ucd4d', '\ubdaa', '\uad8b', '\u9de8', '\u8dc9', '\u7c26', '\u6c07', '\u5c64', '\u4c45', '\u3ca2', '\u2c83', '\u1ce0', '\u0cc1', '\uef1f', '\uff3e', '\ucf5d', '\udf7c', '\uaf9b', '\ubfba', '\u8fd9', '\u9ff8', '\u6e17', '\u7e36', '\u4e55', '\u5e74', '\u2e93', '\u3eb2', '\u0ed1', '\u1ef0'};
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final Integer ITERATION_COUNT = 11208;
    public static final byte[] SALT = new byte[]{122, -84};
    public static final byte[] IV1 = new byte[]{87, 82};
    public static final byte[] IV2 = new byte[]{-7, 57};

    private AESCryptor() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] secureRandom(int len) throws NoSuchAlgorithmException {
        SecureRandom random = SecureRandom.getInstanceStrong();
        byte[] bytes = new byte[len];
        random.nextBytes(bytes);
        return bytes;
    }

    private static byte[] getInitVector(byte[] iv) {
        if (iv.length < 16) {
            return iv;
        }
        byte[] initVector = new byte[iv.length];
        initVector[0] = (byte)(initVector[0] | initVector[5]);
        initVector[1] = (byte)(initVector[12] | initVector[14]);
        initVector[2] = (byte)(initVector[15] - initVector[12]);
        initVector[3] = (byte)(initVector[4] + initVector[5]);
        initVector[4] = (byte)(initVector[13] | initVector[11]);
        initVector[5] = (byte)(initVector[10] & initVector[4]);
        initVector[6] = (byte)(initVector[13] & initVector[0]);
        initVector[7] = (byte)(initVector[13] - initVector[11]);
        initVector[8] = (byte)(initVector[5] + initVector[15]);
        initVector[9] = (byte)(initVector[5] | initVector[11]);
        initVector[10] = (byte)(initVector[12] + initVector[0]);
        initVector[11] = (byte)(initVector[14] - initVector[4]);
        initVector[12] = (byte)(initVector[7] - initVector[9]);
        initVector[13] = (byte)(initVector[11] & initVector[3]);
        initVector[14] = (byte)(initVector[14] & initVector[0]);
        initVector[15] = (byte)(initVector[2] & initVector[14]);
        return initVector;
    }

    private static byte[] getCfgFactor(String filePath, boolean hasCrc) throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String factor = reader.readLine().trim();
            if (hasCrc) {
                int crc;
                String factorCrc = reader.readLine().trim();
                char tmpCrc = AESCryptor.calculateCrc(Base64.getDecoder().decode(factor));
                byte[] byArray = tmpCrc == (crc = Integer.parseInt(factorCrc)) ? Base64.getDecoder().decode(factor) : null;
                return byArray;
            }
            byte[] byArray = Base64.getDecoder().decode(factor);
            return byArray;
        }
    }

    public static byte[] encrypt(byte[] plainText, byte[] key, byte[] iv) throws Exception {
        if (key == null || key.length != 16 || iv == null || iv.length != 16) {
            throw new Exception("AESCryptor encryptData error!");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)secretKeySpec, ivSpec);
        return cipher.doFinal(plainText);
    }

    public static byte[] decrypt(byte[] cipherText, byte[] key, byte[] iv) throws Exception {
        if (key == null || key.length != 16 || iv == null || iv.length != 16) {
            throw new Exception("AESCryptor decryptData error!");
        }
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, (Key)keySpec, ivSpec);
        return cipher.doFinal(cipherText);
    }

    private static byte[] deriveKey(byte[] password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] saltShuffle = AESCryptor.getInitVector(salt);
        SecretKeySpec keySpec = new SecretKeySpec(password, "HmacSHA256");
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(keySpec);
        int hmacLength = mac.getMacLength();
        int l = Math.max(16, hmacLength);
        int r = 16 - (l - 1) * hmacLength;
        byte[] deriveKey1 = new byte[l * hmacLength];
        int tiOffset = 0;
        for (int i = 1; i <= l; ++i) {
            AESCryptor.doUpdate(deriveKey1, tiOffset, mac, saltShuffle, i);
            tiOffset += hmacLength;
        }
        if (r < hmacLength) {
            byte[] deriveKey2 = new byte[16];
            System.arraycopy(deriveKey1, 0, deriveKey2, 0, 16);
            return deriveKey2;
        }
        return deriveKey1;
    }

    private static void doUpdate(byte[] dest, int offset, Mac mac, byte[] src, int blockIndex) {
        int hmacLength = mac.getMacLength();
        byte[] uResult = new byte[hmacLength];
        byte[] uIndex = new byte[src.length + 4];
        System.arraycopy(src, 0, uIndex, 0, src.length);
        uIndex[src.length] = (byte)(blockIndex / 0x1000000);
        uIndex[src.length + 1] = (byte)(blockIndex / 65536);
        uIndex[src.length + 2] = (byte)(blockIndex / 256);
        uIndex[src.length + 3] = (byte)blockIndex;
        for (int i = 0; i < ITERATION_COUNT; ++i) {
            uIndex = mac.doFinal(uIndex);
            for (int j = 0; j < uResult.length; ++j) {
                int n = j;
                uResult[n] = (byte)(uResult[n] ^ uIndex[j]);
            }
        }
        System.arraycopy(uResult, 0, dest, offset, hmacLength);
    }

    private static char calculateCrc(byte[] pByte) {
        int len = pByte.length;
        char crc = '\u0000';
        int i = 0;
        while (len-- != 0) {
            byte da = (byte)(crc >> 8);
            crc = (char)(crc << 8);
            int num = da ^ pByte[i];
            if (num < 0) {
                num += 256;
            }
            crc = (char)(crc ^ CRC_TB[num]);
            ++i;
        }
        return crc;
    }

    public static String doDecrypt(String cipherText, byte[] salt, byte[] iv1, byte[] iv2, String factorPath, String dataKeyCipherTextPath) throws Exception {
        byte[] factor = AESCryptor.getCfgFactor(factorPath, true);
        if (factor == null) {
            throw new Exception("read factor error!");
        }
        byte[] workKey = AESCryptor.deriveKey(factor, salt);
        byte[] dataKeyCipherText = AESCryptor.getCfgFactor(dataKeyCipherTextPath, true);
        if (dataKeyCipherText == null) {
            throw new Exception("read dataKey cipher text error!");
        }
        byte[] dataKey = AESCryptor.decrypt(dataKeyCipherText, workKey, iv1);
        byte[] plainText = AESCryptor.decrypt(Base64.getDecoder().decode(cipherText), dataKey, iv2);
        return new String(plainText);
    }

    public static String doEncrypt(String plainText, byte[] salt, byte[] iv1, byte[] iv2, String factorPath, String dataKeyCipherTextPath) throws Exception {
        BufferedWriter writer;
        if (plainText == null || factorPath == null || dataKeyCipherTextPath == null) {
            return null;
        }
        File file1 = new File(factorPath);
        File file2 = new File(dataKeyCipherTextPath);
        boolean factorExists = file1.exists() && file1.length() > 0L;
        boolean datakeyExists = file2.exists() && file2.length() > 0L;
        byte[] factor = factorExists ? AESCryptor.getCfgFactor(factorPath, true) : AESCryptor.secureRandom(16);
        byte[] workKey = AESCryptor.deriveKey(factor, salt);
        byte[] dataKeyCipherText = datakeyExists ? AESCryptor.getCfgFactor(dataKeyCipherTextPath, true) : null;
        byte[] dataKey = dataKeyCipherText == null ? AESCryptor.secureRandom(16) : AESCryptor.decrypt(dataKeyCipherText, workKey, iv1);
        byte[] cipherText = AESCryptor.encrypt(plainText.getBytes(), dataKey, iv2);
        if (!factorExists) {
            writer = new BufferedWriter(new FileWriter(factorPath));
            try {
                writer.write(Base64.getEncoder().encodeToString(factor) + "\n");
                writer.write(String.valueOf((int)AESCryptor.calculateCrc(factor)));
            }
            finally {
                writer.close();
            }
        }
        if (!datakeyExists) {
            dataKeyCipherText = AESCryptor.encrypt(dataKey, workKey, iv1);
            writer = new BufferedWriter(new FileWriter(dataKeyCipherTextPath));
            try {
                writer.write(Base64.getEncoder().encodeToString(dataKeyCipherText) + "\n");
                writer.write(String.valueOf((int)AESCryptor.calculateCrc(dataKeyCipherText)));
            }
            finally {
                writer.close();
            }
        }
        return Base64.getEncoder().encodeToString(cipherText);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        AESCryptor.generatePresetIV();
    }

    public static void generatePresetIV() throws NoSuchAlgorithmException {
        System.out.println("SALT=" + AESCryptor.printHex(AESCryptor.secureRandom(16)));
        System.out.println("IV1=" + AESCryptor.printHex(AESCryptor.secureRandom(16)));
        System.out.println("IV2=" + AESCryptor.printHex(AESCryptor.secureRandom(16)));
    }

    private static String printHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("(byte) 0x%02X", data[i]));
            if (i >= data.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

