/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.async;

import bikframework.web.async.AsyncTaskProperties;
import bikframework.web.async.ExceptionHandlingTaskExecutor;
import java.util.concurrent.RejectedExecutionHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public final class AsyncTaskExecutorBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskExecutorBuilder.class);

    public static AsyncTaskExecutor build(AsyncTaskProperties asyncTaskProperties) {
        log.info("Creating async task executor {}", (Object)asyncTaskProperties);
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(asyncTaskProperties.getCorePoolSize());
        executor.setMaxPoolSize(asyncTaskProperties.getMaxPoolSize());
        executor.setQueueCapacity(asyncTaskProperties.getQueueCapacity());
        executor.setThreadNamePrefix(asyncTaskProperties.getThreadNamePrefix());
        executor.initialize();
        return new ExceptionHandlingTaskExecutor(executor);
    }

    public static AsyncTaskExecutor build(AsyncTaskProperties asyncTaskProperties, RejectedExecutionHandler rejectHandler) {
        ExceptionHandlingTaskExecutor result = (ExceptionHandlingTaskExecutor)AsyncTaskExecutorBuilder.build(asyncTaskProperties);
        if (rejectHandler != null) {
            result.getExecutor().setRejectedExecutionHandler(rejectHandler);
        }
        return result;
    }
}

