/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.async;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final ThreadFactory threadFactory;
    private final boolean daemonThread;
    private final AtomicInteger counter = new AtomicInteger();

    public NamedThreadFactory(String prefix, boolean daemonThread) {
        this(prefix, daemonThread, Executors.defaultThreadFactory());
    }

    public NamedThreadFactory(String prefix, boolean daemonThread, ThreadFactory threadFactory) {
        this.prefix = prefix;
        this.threadFactory = threadFactory;
        this.daemonThread = daemonThread;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.threadFactory.newThread(r);
        t.setDaemon(this.daemonThread);
        t.setName(this.prefix + "-Thread-" + this.counter.incrementAndGet());
        return t;
    }
}

