/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.domain;

import bikframework.web.domain.ApiBaseResponse;
import java.util.List;
import lombok.Generated;

public class ApiPagingResponse<T>
extends ApiBaseResponse {
    protected List<T> result;
    protected long totalCount;
    protected long pageCount;
    protected long pageId;
    protected long pageSize;

    public static <T> ApiPagingResponse<T> succeed(List<T> results, long totalCount, int pageId, int pageSize) {
        ApiPagingResponse<T> response = new ApiPagingResponse<T>();
        response.result = results;
        if (results == null) {
            response.pageId = 1L;
            response.pageCount = 0L;
            response.totalCount = 0L;
        } else {
            response.pageId = pageId;
            response.totalCount = totalCount;
            if (pageSize <= 0) {
                response.pageCount = 0L;
            } else {
                long totalPage = response.totalCount / (long)pageSize;
                response.pageCount = response.totalCount % (long)pageSize > 0L ? totalPage + 1L : totalPage;
            }
        }
        return response;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiPagingResponse)) {
            return false;
        }
        ApiPagingResponse other = (ApiPagingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getPageCount() != other.getPageCount()) {
            return false;
        }
        if (this.getPageId() != other.getPageId()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        List<T> this$result = this.getResult();
        List<T> other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiPagingResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $totalCount = this.getTotalCount();
        result = result * 59 + (int)($totalCount >>> 32 ^ $totalCount);
        long $pageCount = this.getPageCount();
        result = result * 59 + (int)($pageCount >>> 32 ^ $pageCount);
        long $pageId = this.getPageId();
        result = result * 59 + (int)($pageId >>> 32 ^ $pageId);
        long $pageSize = this.getPageSize();
        result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
        List<T> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public ApiPagingResponse() {
    }

    @Generated
    public List<T> getResult() {
        return this.result;
    }

    @Generated
    public long getTotalCount() {
        return this.totalCount;
    }

    @Generated
    public long getPageCount() {
        return this.pageCount;
    }

    @Generated
    public long getPageId() {
        return this.pageId;
    }

    @Generated
    public long getPageSize() {
        return this.pageSize;
    }

    @Generated
    public void setResult(List<T> result) {
        this.result = result;
    }

    @Generated
    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Generated
    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    @Generated
    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    @Generated
    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    @Generated
    public String toString() {
        return "ApiPagingResponse(result=" + String.valueOf(this.getResult()) + ", totalCount=" + this.getTotalCount() + ", pageCount=" + this.getPageCount() + ", pageId=" + this.getPageId() + ", pageSize=" + this.getPageSize() + ")";
    }
}

