/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.data;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;

public class I18nTools {
    public static final String LANG_EN = "en";

    public static String buildI18nKey(String lang, String key) {
        String langStr = lang.toLowerCase();
        if (Strings.isNullOrEmpty((String)langStr)) {
            langStr = LANG_EN;
        }
        String keyStr = Strings.nullToEmpty((String)key);
        if (key.length() > 32) {
            keyStr = Hashing.hmacMd5((byte[])"live".getBytes()).hashString((CharSequence)keyStr, Charsets.UTF_8).toString();
        }
        return String.format("%s.%s", langStr, keyStr);
    }

    public static boolean isLangEN(String langCode) {
        return Strings.nullToEmpty((String)langCode).equalsIgnoreCase(LANG_EN);
    }
}

