/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.client;

import bikframework.log.model.InvokeLogBean;
import bikframework.log.trace.TraceContext;
import bikframework.utils.DateUtils;
import bikframework.utils.GsonUtils;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class ClientLogRequestInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientLogRequestInterceptor.class);
    private static final Logger RPC_LOG = LoggerFactory.getLogger((String)"rpcLog");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        long invokeStartTime = System.currentTimeMillis();
        InvokeLogBean invokeStartLogBean = this.recordInvokeStartLogBean(request);
        ClientHttpResponse response = null;
        try {
            ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
            return clientHttpResponse;
        }
        finally {
            this.recordInvokeEndLogBean(invokeStartLogBean, response, invokeStartTime);
        }
    }

    private InvokeLogBean recordInvokeStartLogBean(HttpRequest request) {
        InvokeLogBean logBean = null;
        try {
            logBean = new InvokeLogBean();
            logBean.setTrace(TraceContext.getBean());
            logBean.setRpcProtocol("okhttp");
            logBean.setHttpMethod(request.getMethod().name());
            logBean.setUrl(Objects.toString(request.getURI()));
            logBean.setOperation("start");
            RPC_LOG.info(GsonUtils.toJson(logBean));
        }
        catch (Exception e) {
            log.info("Record restClient invoke start log error", (Throwable)e);
        }
        return logBean;
    }

    private void recordInvokeEndLogBean(InvokeLogBean invokeStartLogBean, ClientHttpResponse response, long invokeStartTime) {
        if (null != invokeStartLogBean) {
            try {
                long costTime = System.currentTimeMillis() - invokeStartTime;
                invokeStartLogBean.setInvokeTime(DateUtils.formatTime(LocalDateTime.now()));
                invokeStartLogBean.setOperation("end");
                invokeStartLogBean.setCostTime(costTime);
                if (null != response) {
                    invokeStartLogBean.setHttpStatus(response.getStatusCode().value());
                    invokeStartLogBean.setError(response.getStatusText());
                    RPC_LOG.info(GsonUtils.toJson(invokeStartLogBean));
                }
            }
            catch (Exception e) {
                log.info("Record restClient invoke end log error", (Throwable)e);
            }
        }
    }
}

