/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipUtils {
    private static final Logger logger = LoggerFactory.getLogger(GZipUtils.class);
    private static final int GZIP_READ_BLOCK_SIZE = 1024;
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";
    public static final String GZIP_ENCODE = "ISO-8859-1";

    /*
     * Enabled aggressive exception aggregation
     */
    public static String compress(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return "";
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            String string;
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(str.getBytes());
                gzip.close();
                string = out.toString("ISO-8859-1");
            }
            return string;
        }
        catch (Exception e) {
            logger.error("Gzip compress exception str[{}] err[{}] ", (Object)str, (Object)e);
            return "";
        }
    }

    /*
     * Exception decompiling
     */
    public static String decompress(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

