/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.data.type;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtils {
    private static final Logger logger = LoggerFactory.getLogger(NumberUtils.class);

    public static Integer str2int(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return -1;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.error("{}", (Throwable)e);
            return -1;
        }
    }

    public static double doublePrecision(double d, int precision) {
        BigDecimal b = new BigDecimal(d);
        return b.setScale(precision, 4).doubleValue();
    }

    public static Object toNumeric(Class clazz, String value) {
        try {
            if (clazz == Long.class) {
                return Long.parseLong(value);
            }
            if (clazz == Integer.class) {
                return Integer.parseInt(value);
            }
            if (clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (clazz == Double.class) {
                return Double.parseDouble(value);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("ToNumeric exception:{}", (Throwable)e);
            return null;
        }
    }

    public static int unsignedMinus(int i1, int i2) {
        if (i1 >= i2) {
            return i1 - i2;
        }
        return 0;
    }

    public static int random(int min, int max) {
        Double d = (double)min + Math.random() * (double)(max - min);
        return d.intValue();
    }

    public static Long nullToZero(Long v) {
        return v == null ? 0L : v;
    }

    public static Integer nullToZero(Integer v) {
        return v == null ? 0 : v;
    }
}

