/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.token.serializer;

import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ByteBufferBuilder {
    private final byte TYPE_INT = 1;
    private final byte TYPE_LONG = (byte)2;
    private final byte TYPE_STRING = (byte)3;
    ByteBuffer buffer;
    int capacity = -1;

    public ByteBufferBuilder() {
        this(0x100000);
    }

    public ByteBufferBuilder(int capacity) {
        this.capacity = capacity <= 0 ? 0x100000 : capacity;
        this.buffer = ByteBuffer.allocate(this.capacity);
    }

    public ByteBufferBuilder(byte[] bytes) {
        this.buffer = ByteBuffer.wrap(bytes);
    }

    public ByteBufferBuilder putInt(String key, int value) {
        this.putString(key);
        this.putInt(value);
        return this;
    }

    public ByteBufferBuilder putLong(String key, long value) {
        this.putString(key);
        this.putLong(value);
        return this;
    }

    public ByteBufferBuilder putString(String key, String value) {
        this.putString(key);
        this.putString(value);
        return this;
    }

    public ByteBufferBuilder put(String key, Object value) {
        if (value instanceof Integer) {
            this.putInt(key, (Integer)value);
        } else if (value instanceof Long) {
            this.putLong(key, (Long)value);
        } else if (value instanceof String) {
            this.putString(key, (String)value);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported Key[{}] type[{}]", key, value.getClass()));
        }
        return this;
    }

    public ByteBufferBuilder putString(String value) {
        this.buffer.put((byte)3);
        this.buffer.putShort((short)value.length());
        this.buffer.put(value.getBytes());
        return this;
    }

    public ByteBufferBuilder putInt(int value) {
        this.buffer.put((byte)1);
        this.buffer.putInt(value);
        return this;
    }

    public ByteBufferBuilder putLong(long value) {
        this.buffer.put((byte)2);
        this.buffer.putLong(value);
        return this;
    }

    public byte[] getAndReset() {
        int len = this.buffer.position();
        this.buffer.flip();
        byte[] value = new byte[len];
        this.buffer.get(value, 0, value.length);
        return value;
    }

    public Object getObject() {
        if (!this.buffer.hasRemaining()) {
            return null;
        }
        byte type = this.buffer.get();
        if (type == 1) {
            return this.buffer.getInt();
        }
        if (type == 2) {
            return this.buffer.getLong();
        }
        if (type == 3) {
            short len = this.buffer.getShort();
            byte[] value = new byte[len];
            this.buffer.get(value);
            return new String(value);
        }
        return null;
    }

    public List readToList() {
        ArrayList valueList = Lists.newArrayList();
        Object value = null;
        while ((value = this.getObject()) != null) {
            valueList.add(value);
        }
        return valueList;
    }
}

