/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.request;

import bikframework.log.request.RequestLogAspect;
import bikframework.log.request.RequestLogFilter;
import bikframework.log.request.RequestLogProperties;
import jakarta.servlet.Filter;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Filter.class})
@ConditionalOnProperty(prefix="bikframework.log.request", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={RequestLogProperties.class})
public class RequestLogAutoConfiguration {
    private final RequestLogProperties requestLogProperties;

    @Bean
    public FilterRegistrationBean<RequestLogFilter> requestLogFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new RequestLogFilter());
        registrationBean.addInitParameter("NEED_RESULT", String.valueOf(this.requestLogProperties.isNeedParam()));
        registrationBean.addInitParameter("NEED_PARAM", String.valueOf(this.requestLogProperties.isNeedParam()));
        registrationBean.addInitParameter("MAX_RESULT_LENGTH", String.valueOf(this.requestLogProperties.getMaxResultLength()));
        registrationBean.addInitParameter("MAX_BODY_LENGTH", String.valueOf(this.requestLogProperties.getMaxBodyLength()));
        registrationBean.addInitParameter("EXCLUDE_PATTERNS", this.requestLogProperties.getExcludePatterns());
        registrationBean.addInitParameter("EXCLUDE_METHODS", this.requestLogProperties.getExcludeMethods());
        registrationBean.addInitParameter("EXCLUDE_HEADERS", this.requestLogProperties.getExcludeHeaders());
        registrationBean.addInitParameter("INCLUDE_HEADERS", this.requestLogProperties.getIncludeHeaders());
        registrationBean.addInitParameter("DESENSITIZATION_HEADERS", this.requestLogProperties.getDesensitizationHeaders());
        registrationBean.addInitParameter("DESENSITIZATION_CONTENT_URI_PATTERNS", this.requestLogProperties.getDesensitizationContentUriPatterns());
        registrationBean.addInitParameter("RECORD_TYPE", this.requestLogProperties.getRecordType());
        registrationBean.addUrlPatterns(this.requestLogProperties.getUrlPatterns());
        registrationBean.setOrder(this.requestLogProperties.getOrder());
        return registrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestLogAspect requestLogAspect() {
        return new RequestLogAspect();
    }

    @Generated
    public RequestLogAutoConfiguration(RequestLogProperties requestLogProperties) {
        this.requestLogProperties = requestLogProperties;
    }
}

