/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.exception;

import bikframework.web.domain.ApiException;
import bikframework.web.domain.ApiResponse;
import bikframework.web.domain.EAppApiErrCode;
import bikframework.web.exception.GlobalExceptionProperties;
import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Order(value=0)
@ControllerAdvice
@EnableConfigurationProperties(value={GlobalExceptionProperties.class})
@ConditionalOnProperty(prefix="bikframework.exception.handler", name={"domain"}, matchIfMissing=true, havingValue="vvf")
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final GlobalExceptionProperties globalExceptionProperties;

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse missingParam(MissingServletRequestParameterException exception) {
        log.error("Missing param ", (Throwable)exception);
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse httpMessageNotReadable(HttpMessageNotReadableException exception) {
        log.error("Message not readable ", (Throwable)exception);
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.SERVER_INTERNAL_ERROR.getCode());
        apiResponse.setMessage(EAppApiErrCode.SERVER_INTERNAL_ERROR.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse httpMediaTypeNotSupport(HttpMediaTypeNotSupportedException exception) {
        log.error("Media type not support", (Throwable)exception);
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse methodNotSupport(HttpServletRequest request) {
        String httpMethod = request.getMethod().toUpperCase();
        log.error("Not support http method {} {}", (Object)httpMethod, (Object)request.getRequestURI());
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> methodArgumentNotValidException(MethodArgumentNotValidException exception) {
        log.error("Param invalid", (Throwable)exception);
        if (this.globalExceptionProperties.isPrintableDetails()) {
            String msg = exception.getBindingResult().getFieldErrors().stream().map(n -> String.format("%s: %s", n.getField(), n.getDefaultMessage())).reduce((x, y) -> String.format("%s; %s", x, y)).orElse("Param invalid");
            ApiResponse<Object> apiResponse = new ApiResponse<Object>();
            apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
            apiResponse.setMessage(msg);
            return apiResponse;
        }
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> bindException(BindException exception) {
        log.error("Param invalid", (Throwable)exception);
        if (this.globalExceptionProperties.isPrintableDetails()) {
            String msg = exception.getBindingResult().getFieldErrors().stream().map(n -> String.format("%s: %s", n.getField(), n.getDefaultMessage())).reduce((x, y) -> String.format("%s; %s", x, y)).orElse("Param invalid");
            ApiResponse<Object> apiResponse = new ApiResponse<Object>();
            apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
            apiResponse.setMessage(msg);
            return apiResponse;
        }
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={ApiException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> businessException(ApiException exception) {
        log.error("Business exception", (Throwable)exception);
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> serverError(Throwable exception) {
        log.error("Server error", exception);
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(EAppApiErrCode.SERVER_ERROR.getCode());
        apiResponse.setMessage(EAppApiErrCode.SERVER_ERROR.getDesc());
        return apiResponse;
    }

    @Generated
    public GlobalExceptionHandler(GlobalExceptionProperties globalExceptionProperties) {
        this.globalExceptionProperties = globalExceptionProperties;
    }
}

