/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.configcenter;

import bikframework.config.config.ConfigValueTools;
import bikframework.config.config.listener.IConfigChangeListener;
import bikframework.config.configcenter.ConfigCenterListener;
import bikframework.config.configcenter.common.ConfigOverrideTools;
import bikframework.config.model.ConfigCenterConfigDTO;
import bikframework.config.model.ConfigFileDTO;
import bikframework.config.model.ConfigItemDTO;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCenterService.class);
    private ConfigCenterConfigDTO serverConfig;
    private Properties properties = new Properties();

    public ConfigCenterService(ConfigCenterConfigDTO serverConfig) {
        this.serverConfig = serverConfig;
    }

    public ConfigCenterService load(IConfigChangeListener listener) {
        this.initProperties();
        for (ConfigItemDTO namespaceConfig : this.serverConfig.getConfigItems()) {
            this.loadConfigByNamespace(listener, namespaceConfig);
        }
        return this;
    }

    private void loadConfigByNamespace(IConfigChangeListener listener, ConfigItemDTO namespaceInfo) {
        this.properties.put("namespace", namespaceInfo.getNamespaceId());
        logger.info("loading namespace[{}]...", (Object)namespaceInfo.getNamespaceId());
        try {
            ConfigService configService = NacosFactory.createConfigService((Properties)this.properties);
            for (ConfigFileDTO configFile : namespaceInfo.getConfigFiles()) {
                Map<String, Integer> configFileMap = ConfigOverrideTools.getDataIdsWithWeights(configFile.getConfigFileName());
                ConfigValueTools.registerListener(configFileMap, listener);
                for (Map.Entry<String, Integer> entry : configFileMap.entrySet()) {
                    this.loadAndListenerByConfigFile(configService, configFile, entry);
                }
            }
        }
        catch (NacosException e) {
            logger.warn("Init Namespace error code[{}],msg[{}],namespaceId[{}]", new Object[]{e.getErrCode(), e.getErrMsg(), namespaceInfo.getNamespaceId()});
        }
    }

    private void loadAndListenerByConfigFile(ConfigService configService, ConfigFileDTO configFile, Map.Entry<String, Integer> entry) {
        try {
            String content = configService.getConfig(entry.getKey(), configFile.getGroup(), this.serverConfig.getReadTimeout() * 1000L);
            logger.info("loading config group[{}] dataId[{}] contentSize[{}]", new Object[]{configFile.getGroup(), entry.getKey(), StringUtils.length((CharSequence)content)});
            ConfigValueTools.update(entry.getKey(), content);
            configService.addListener(entry.getKey(), configFile.getGroup(), (Listener)new ConfigCenterListener(entry.getKey()));
        }
        catch (NacosException e) {
            logger.warn("Get and listener config error code[{}],msg[{}],fileName[{}]", new Object[]{e.getErrCode(), e.getErrMsg(), entry.getKey()});
        }
    }

    private void initProperties() {
        if (!Strings.isNullOrEmpty((String)this.serverConfig.getLocalCacheDir())) {
            System.setProperty("JM.SNAPSHOT.PATH", this.serverConfig.getLocalCacheDir());
        }
        this.properties.put("serverAddr", this.serverConfig.getServerHost());
        this.properties.put("configLongPollTimeout", (Object)this.serverConfig.getConfigLongPollTimeout());
        this.properties.put("configRetryTime", (Object)this.serverConfig.getConfigRetryTime());
        this.properties.put("maxRetry", (Object)this.serverConfig.getMaxRetry());
        this.properties.put("enableRemoteSyncConfig", (Object)this.serverConfig.getEnableRemoteSyncConfig());
        this.properties.put("username", this.serverConfig.getUsername());
        this.properties.put("password", this.serverConfig.getPassword());
    }
}

