/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.file.monitor;

import bikframework.config.config.loader.json.JsonSerialize;
import bikframework.config.file.monitor.FileChangeListenerAdaptor;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonListener<T extends TypeReference, V>
extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(JsonListener.class);
    private T type = null;
    private Map<String, V> value = null;
    private String fn = null;

    public JsonListener(boolean backupAfterProcess, String fn, T type, Map<String, V> valueMap) {
        super(backupAfterProcess);
        this.type = type;
        this.value = valueMap;
        this.fn = fn;
    }

    @Override
    public void onFileCreate(File file) {
        this.loadJson(file);
    }

    @Override
    public void onFileChange(File file) {
        this.loadJson(file);
    }

    public void onFileDelete(File file) {
    }

    public void loadJson(File file) {
        String fn = FilenameUtils.getName((String)file.getName());
        if (this.fn.contentEquals(fn)) {
            this.value.put(fn, JsonSerialize.loadJson(file, this.type));
            logger.info("Load file[{}]", (Object)fn);
        } else {
            logger.info("[SKIP]filename[{}]", (Object)fn);
        }
    }
}

