/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.request;

import bikframework.log.model.ApiDefinition;
import bikframework.utils.ValidatorUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Aspect
public class RequestLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLogAspect.class);
    private static final Set<Class<? extends Annotation>> ANNOTATION_TYPES = new HashSet<Class<? extends Annotation>>(8);

    @Around(value="(@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController))", argNames="joinPoint")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        String clzMethod = null;
        boolean isMatch = false;
        try {
            Signature signature = joinPoint.getSignature();
            if (!(signature instanceof MethodSignature)) {
                return joinPoint.proceed();
            }
            Method method = ((MethodSignature)signature).getMethod();
            Set annotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, ANNOTATION_TYPES);
            if (CollectionUtils.isEmpty((Collection)annotations) && ValidatorUtils.isNullOrEmpty(annotations)) {
                return joinPoint.proceed();
            }
            isMatch = true;
            ApiDefinition apiDefinition = null;
            RequestMapping requestMapping = null;
            PostMapping postMapping = null;
            GetMapping getMapping = null;
            PutMapping putMapping = null;
            DeleteMapping deleteMapping = null;
            for (Annotation annotation : annotations) {
                if (annotation instanceof ApiDefinition) {
                    apiDefinition = (ApiDefinition)annotation;
                    continue;
                }
                if (annotation instanceof RequestMapping) {
                    requestMapping = (RequestMapping)annotation;
                    continue;
                }
                if (annotation instanceof PostMapping) {
                    postMapping = (PostMapping)annotation;
                    continue;
                }
                if (annotation instanceof GetMapping) {
                    getMapping = (GetMapping)annotation;
                    continue;
                }
                if (annotation instanceof PutMapping) {
                    putMapping = (PutMapping)annotation;
                    continue;
                }
                if (!(annotation instanceof DeleteMapping)) continue;
                deleteMapping = (DeleteMapping)annotation;
            }
            clzMethod = new StringJoiner(".").add(signature.getDeclaringTypeName()).add(signature.getName()).toString();
            log.debug("{} in", (Object)clzMethod);
            if (null != apiDefinition) {
                this.recordMapping(clzMethod, apiDefinition);
            } else {
                this.recordMapping(clzMethod, requestMapping, postMapping, getMapping, deleteMapping, putMapping);
            }
            return joinPoint.proceed();
        }
        catch (Throwable e) {
            if (isMatch) {
                String exMsg = e.getCause() == null ? e.getMessage() : e.getCause().getMessage();
                MDC.put((String)"reqLog_exMsg", (String)exMsg);
                log.debug("{} exception occurred, exMsg: {}", clzMethod, (Object)exMsg);
            }
            throw e;
        }
    }

    private void recordMapping(String clzMethod, RequestMapping requestMapping, PostMapping postMapping, GetMapping getMapping, DeleteMapping deleteMapping, PutMapping putMapping) {
        try {
            String mapping = "";
            String mappingMethodsStr = "";
            String mappingName = "";
            if (null != requestMapping) {
                String[] path = requestMapping.path();
                path = path.length == 0 ? requestMapping.value() : path;
                mapping = Arrays.stream(path).collect(Collectors.joining(",", "[", "]"));
                RequestMethod[] mappingMethods = requestMapping.method();
                mappingMethodsStr = Arrays.stream(mappingMethods).map(Enum::toString).collect(Collectors.joining(",", "[", "]"));
                mappingName = requestMapping.name();
            } else if (null != postMapping) {
                String[] path = postMapping.path();
                path = path.length == 0 ? postMapping.value() : path;
                mapping = Arrays.stream(path).collect(Collectors.joining(",", "[", "]"));
                mappingMethodsStr = RequestMethod.POST.toString();
                mappingName = postMapping.name();
            } else if (null != getMapping) {
                String[] path = getMapping.path();
                path = path.length == 0 ? getMapping.value() : path;
                mapping = Arrays.stream(path).collect(Collectors.joining(",", "[", "]"));
                mappingMethodsStr = RequestMethod.GET.toString();
                mappingName = getMapping.name();
            } else if (null != deleteMapping) {
                String[] path = deleteMapping.path();
                path = path.length == 0 ? deleteMapping.value() : path;
                mapping = Arrays.stream(path).collect(Collectors.joining(",", "[", "]"));
                mappingMethodsStr = RequestMethod.DELETE.toString();
                mappingName = deleteMapping.name();
            } else if (null != putMapping) {
                String[] path = putMapping.path();
                path = path.length == 0 ? putMapping.value() : path;
                mapping = Arrays.stream(path).collect(Collectors.joining(",", "[", "]"));
                mappingMethodsStr = RequestMethod.PUT.toString();
                mappingName = putMapping.name();
            }
            MDC.put((String)"reqLog_clzMethod", (String)clzMethod);
            MDC.put((String)"reqLog_mapping", (String)String.format("%s %s", mappingMethodsStr, mapping));
            MDC.put((String)"reqLog_mappingName", (String)mappingName);
        }
        catch (Exception e) {
            log.info("Record controller mapping error {}", (Object)clzMethod, (Object)e);
        }
    }

    private void recordMapping(String clzMethod, ApiDefinition apiDefinition) {
        try {
            String mapping = "";
            String mappingMethodsStr = "";
            String mappingName = "";
            if (null != apiDefinition) {
                String[] path = apiDefinition.path();
                path = path.length == 0 ? apiDefinition.value() : path;
                mapping = Arrays.stream(path).collect(Collectors.joining(",", "[", "]"));
                RequestMethod[] mappingMethods = apiDefinition.method();
                mappingMethodsStr = Arrays.stream(mappingMethods).map(Enum::toString).collect(Collectors.joining(",", "[", "]"));
                mappingName = apiDefinition.name();
            }
            MDC.put((String)"reqLog_clzMethod", (String)clzMethod);
            MDC.put((String)"reqLog_mapping", (String)String.format("%s %s", mappingMethodsStr, mapping));
            MDC.put((String)"reqLog_mappingName", (String)mappingName);
        }
        catch (Exception e) {
            log.info("Record controller mapping error {}", (Object)clzMethod, (Object)e);
        }
    }

    static {
        ANNOTATION_TYPES.add(ApiDefinition.class);
        ANNOTATION_TYPES.add(RequestMapping.class);
        ANNOTATION_TYPES.add(GetMapping.class);
        ANNOTATION_TYPES.add(PostMapping.class);
        ANNOTATION_TYPES.add(PutMapping.class);
        ANNOTATION_TYPES.add(DeleteMapping.class);
    }
}

