/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.request;

import bikframework.log.model.HttpServletRequestCopier;
import bikframework.log.model.HttpServletResponseCopier;
import bikframework.log.model.RequestLogBean;
import bikframework.log.trace.TraceContext;
import bikframework.utils.HttpUtils;
import cn.hutool.crypto.digest.DigestUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import lombok.Generated;
import net.logstash.logback.marker.Markers;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class RequestLogFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLogFilter.class);
    private static final String SEPARATOR = ",";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger REQUEST_LOG = LoggerFactory.getLogger((String)"requestLog");
    private static final String SUB_SUFFIX = "...(source length is %d)";
    private boolean needParam = true;
    private boolean needResult = false;
    private int maxResultLength = 500;
    private int maxBodyLength = 500;
    private String[] excludePatterns;
    private String[] excludeMethods;
    private String[] excludeHeaders;
    private String[] includeHeaders;
    private String[] desensitizationHeaders;
    private String[] desensitizationContentUriPatterns;
    private String recordType = "msg";
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    protected void initFilterBean() throws ServletException {
        String recordTypeStr;
        String initDesensitizationContentUri;
        String initDesensitizationHeaders;
        String initIncludeHeaders;
        String initExcludeHeaders;
        String initExcludeMethods;
        String initExcludePatterns;
        String maxBodyLengthStr;
        super.initFilterBean();
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        FilterConfig filterConfig = this.getFilterConfig();
        if (null == filterConfig) {
            return;
        }
        String needResultStr = filterConfig.getInitParameter("NEED_RESULT");
        this.needResult = Boolean.parseBoolean(needResultStr);
        String needParamStr = filterConfig.getInitParameter("NEED_PARAM");
        this.needParam = Boolean.parseBoolean(needParamStr);
        String maxResultLengthStr = filterConfig.getInitParameter("MAX_RESULT_LENGTH");
        if (StringUtils.isNotBlank((CharSequence)maxResultLengthStr)) {
            this.maxResultLength = Integer.parseInt(maxResultLengthStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(maxBodyLengthStr = filterConfig.getInitParameter("MAX_BODY_LENGTH")))) {
            this.maxBodyLength = Integer.parseInt(maxBodyLengthStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(initExcludePatterns = filterConfig.getInitParameter("EXCLUDE_PATTERNS")))) {
            this.excludePatterns = initExcludePatterns.split(SEPARATOR);
        }
        if (StringUtils.isNotBlank((CharSequence)(initExcludeMethods = filterConfig.getInitParameter("EXCLUDE_METHODS")))) {
            this.excludeMethods = initExcludeMethods.split(SEPARATOR);
        }
        if (StringUtils.isNotBlank((CharSequence)(initExcludeHeaders = filterConfig.getInitParameter("EXCLUDE_HEADERS")))) {
            this.excludeHeaders = initExcludeHeaders.split(SEPARATOR);
        }
        if (StringUtils.isNotBlank((CharSequence)(initIncludeHeaders = filterConfig.getInitParameter("INCLUDE_HEADERS")))) {
            this.includeHeaders = initIncludeHeaders.split(SEPARATOR);
        }
        if (StringUtils.isNotBlank((CharSequence)(initDesensitizationHeaders = filterConfig.getInitParameter("DESENSITIZATION_HEADERS")))) {
            this.desensitizationHeaders = initDesensitizationHeaders.split(SEPARATOR);
        }
        if (StringUtils.isNotBlank((CharSequence)(initDesensitizationContentUri = filterConfig.getInitParameter("DESENSITIZATION_CONTENT_URI_PATTERNS")))) {
            this.desensitizationContentUriPatterns = initDesensitizationContentUri.split(SEPARATOR);
        }
        if (StringUtils.isNotBlank((CharSequence)(recordTypeStr = this.getFilterConfig().getInitParameter("RECORD_TYPE")))) {
            this.recordType = recordTypeStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String requestUri = httpRequest.getRequestURI();
            String method = httpRequest.getMethod();
            if (this.isExcludePath(requestUri) || this.isExcludeMethod(method)) {
                chain.doFilter(request, response);
                return;
            }
            RequestLogBean logBean = new RequestLogBean();
            long startTimeMills = System.currentTimeMillis();
            if (response.getCharacterEncoding() == null) {
                response.setCharacterEncoding("UTF-8");
            }
            HttpServletResponseCopier responseCopier = null;
            HttpServletRequestCopier requestCopier = null;
            try {
                responseCopier = new HttpServletResponseCopier((HttpServletResponse)response);
                requestCopier = request instanceof HttpServletRequestCopier ? (HttpServletRequestCopier)request : new HttpServletRequestCopier((HttpServletRequest)request);
                chain.doFilter((ServletRequest)requestCopier, (ServletResponse)responseCopier);
                return;
            }
            finally {
                try {
                    logBean.setCostTime(System.currentTimeMillis() - startTimeMills);
                    logBean.setUri(requestUri);
                    logBean.setHttpMethod(method);
                    logBean.setFromIp(HttpUtils.getRealRemoteIp((HttpServletRequest)request));
                    logBean.setMapping(MDC.get((String)"reqLog_mapping"));
                    logBean.setMappingName(MDC.get((String)"reqLog_mappingName"));
                    logBean.setClzMethod(MDC.get((String)"reqLog_clzMethod"));
                    String exMsg = MDC.get((String)"reqLog_exMsg");
                    if (this.needParam && null != requestCopier) {
                        logBean.setParam(this.getParam(requestCopier));
                    }
                    RequestLogBean.Result result = new RequestLogBean.Result();
                    result.setStatus(((HttpServletResponse)response).getStatus());
                    if (this.needResult && null != responseCopier) {
                        String responseContent = this.getOutputParamJsonStr(responseCopier, requestUri);
                        result.setContent(this.truncString(responseContent, this.maxResultLength));
                    }
                    result.setExceptionMsg(exMsg);
                    logBean.setResult(result);
                    logBean.setTrace(TraceContext.getBean());
                    this.recordLog(logBean, StringUtils.isNotBlank((CharSequence)exMsg));
                    MDC.clear();
                }
                catch (Exception ex) {
                    log.info("Exception occurred while recording request log", (Throwable)ex);
                }
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isExcludePath(String requestUri) {
        if (null == this.excludePatterns) {
            return false;
        }
        for (String pattern : this.excludePatterns) {
            if (!this.pathMatcher.match(pattern.trim(), requestUri)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeMethod(String method) {
        if (null == this.excludeMethods) {
            return false;
        }
        for (String excludeMethod : this.excludeMethods) {
            if (!excludeMethod.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    private boolean isExcludeHeaders(String header) {
        if (null == this.excludeHeaders) {
            return false;
        }
        for (String excludeHeader : this.excludeHeaders) {
            if (!excludeHeader.trim().equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludeHeaders(String header) {
        if (null == this.includeHeaders) {
            return true;
        }
        for (String includeHeader : this.includeHeaders) {
            if (!includeHeader.trim().equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    private boolean isDesensitizationHeaders(String header) {
        if (null == this.desensitizationHeaders) {
            return true;
        }
        for (String desensitizationHeader : this.desensitizationHeaders) {
            if (!desensitizationHeader.trim().equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }

    private String valueDesensitization(String header, String plain) {
        if (this.isDesensitizationHeaders(header) && StringUtils.isNotBlank((CharSequence)plain)) {
            return DigestUtil.sha1Hex((String)plain);
        }
        return plain;
    }

    private RequestLogBean.Param getParam(HttpServletRequestCopier requestCopier) {
        String paramMap = null;
        try {
            paramMap = OBJECT_MAPPER.writeValueAsString((Object)requestCopier.getParameterMap());
        }
        catch (JsonProcessingException e) {
            log.info("Exception occurred while processing JSON for request log", (Throwable)e);
        }
        String queryStr = requestCopier.getQueryString();
        try {
            queryStr = null != queryStr ? URLDecoder.decode(queryStr, requestCopier.getCharacterEncoding()) : null;
        }
        catch (UnsupportedEncodingException e) {
            log.debug("URL decode [{}] by [{}] failed.", new Object[]{queryStr, requestCopier.getCharacterEncoding(), e});
        }
        Enumeration headers = requestCopier.getHeaderNames();
        HashMap<String, String> headersMap = new HashMap<String, String>(8);
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (null != this.includeHeaders && this.includeHeaders.length > 0) {
                if (!this.isIncludeHeaders(header)) continue;
                headersMap.put(header, this.valueDesensitization(header, requestCopier.getHeader(header)));
                continue;
            }
            if (this.isExcludeHeaders(header)) continue;
            headersMap.put(header, this.valueDesensitization(header, requestCopier.getHeader(header)));
        }
        String payload = HttpUtils.getRequestBody(requestCopier, true);
        payload = this.truncString(payload, this.maxBodyLength);
        return new RequestLogBean.Param(headersMap, queryStr, payload, paramMap);
    }

    private void recordLog(RequestLogBean requestLogBean, boolean hasError) throws JsonProcessingException {
        if ("marker".equals(this.recordType)) {
            if (hasError) {
                REQUEST_LOG.error((Marker)Markers.appendFields((Object)requestLogBean), "");
            } else {
                REQUEST_LOG.info((Marker)Markers.appendFields((Object)requestLogBean), "");
            }
        } else if (hasError) {
            REQUEST_LOG.error(OBJECT_MAPPER.writeValueAsString((Object)requestLogBean));
        } else {
            REQUEST_LOG.info(OBJECT_MAPPER.writeValueAsString((Object)requestLogBean));
        }
    }

    private String getOutputParamJsonStr(HttpServletResponseCopier responseCopier, String requestUri) {
        String contentType = responseCopier.getContentType();
        try {
            responseCopier.flushBuffer();
            byte[] copy = responseCopier.getCopy();
            if (null == contentType || contentType.contains("text") || contentType.contains("json")) {
                String content = new String(copy, responseCopier.getCharacterEncoding());
                if (this.isDesensitizationContentUri(requestUri)) {
                    return this.contentDesensitization(content);
                }
                return content;
            }
            return String.format("Unable to get content. contentType:%s, contentLength:%s bytes", contentType, copy.length);
        }
        catch (Exception e) {
            log.warn("Failed to encapsulate HTTP interface log return value", (Throwable)e);
            return null;
        }
    }

    private boolean isDesensitizationContentUri(String requestUri) {
        if (null == this.desensitizationContentUriPatterns) {
            return false;
        }
        for (String pattern : this.desensitizationContentUriPatterns) {
            if (!this.pathMatcher.match(pattern.trim(), requestUri)) continue;
            return true;
        }
        return false;
    }

    private String contentDesensitization(String plain) {
        return DigestUtil.sha1Hex((String)plain);
    }

    private String truncString(String str, int maxLength) {
        if (null == str) {
            return "";
        }
        if (str.length() > maxLength) {
            String subSuffix = String.format(SUB_SUFFIX, str.length());
            return str.substring(0, maxLength - subSuffix.length()) + subSuffix;
        }
        return str;
    }
}

