/*
 * Decompiled with CFR 0.152.
 */
package bikframework.log.trace.core;

import bikframework.log.trace.TraceContext;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceOkhttpInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceOkhttpInterceptor.class);

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        if (chain == null) {
            throw new NullPointerException("chain is marked non-null but is null");
        }
        Request request = this.addHeader(chain.request());
        return chain.proceed(request);
    }

    private Request addHeader(Request request) {
        try {
            String spanId;
            Request.Builder requestBuilder = request.newBuilder();
            String traceId = TraceContext.getTraceId();
            if (StringUtils.isNotBlank((CharSequence)traceId)) {
                requestBuilder.header("eTraceId", traceId);
            }
            if (StringUtils.isNotBlank((CharSequence)(spanId = TraceContext.getSpanId()))) {
                requestBuilder.header("eSpanId", spanId);
            }
            return requestBuilder.build();
        }
        catch (Exception e) {
            log.info("OkHttp add trace header error", (Throwable)e);
            return request;
        }
    }
}

