/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.encrypt;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESIVUtils {
    private static final Logger logger = LoggerFactory.getLogger(AESIVUtils.class);

    public static byte[] encrypt(byte[] input, byte[] key, byte[] iv) {
        byte[] crypted = null;
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)skey, ivSpec);
            crypted = cipher.doFinal(input);
        }
        catch (Exception e) {
            logger.error("AESIVTools.encrypt", (Throwable)e);
        }
        return crypted;
    }

    public static byte[] decrypt(byte[] input, byte[] key, byte[] iv) {
        try {
            byte[] output = null;
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)skey, ivSpec);
            output = cipher.doFinal(input);
            return output;
        }
        catch (Exception e) {
            logger.error("AESIVTools.decrypt", (Throwable)e);
            return null;
        }
    }

    public static String encrypt(String input, String key, String iv) {
        byte[] keyBytes = Base64.decodeBase64((String)key);
        byte[] crypted = AESIVUtils.encrypt(input.getBytes(), keyBytes, iv.getBytes());
        return Base64.encodeBase64URLSafeString((byte[])crypted);
    }

    public static String decrypt(String input, String key, String iv) {
        byte[] keyBytes;
        byte[] inputBytes = Base64.decodeBase64((String)input);
        byte[] bytes = AESIVUtils.decrypt(inputBytes, keyBytes = Base64.decodeBase64((String)key), iv.getBytes());
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }
}

