/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.async;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ExceptionHandlingTaskExecutor
implements AsyncTaskExecutor,
InitializingBean,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlingTaskExecutor.class);
    private final ThreadPoolTaskExecutor executor;

    public ThreadPoolTaskExecutor getExecutor() {
        return this.executor;
    }

    public void destroy() throws Exception {
        if (null != this.executor) {
            this.executor.destroy();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (null != this.executor) {
            this.executor.afterPropertiesSet();
        }
    }

    public void execute(@NonNull Runnable task, long startTimeout) {
        this.executor.execute(this.createWrappedRunnable(task), startTimeout);
    }

    public void execute(@NonNull Runnable task) {
        this.executor.execute(task);
    }

    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        return this.executor.submit(this.createWrappedRunnable(task));
    }

    @NonNull
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        return this.executor.submit(this.createCallable(task));
    }

    protected void handle(Exception e) {
        log.error("Caught async exception", (Throwable)e);
    }

    private <T> Callable<T> createCallable(Callable<T> task) {
        return () -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                this.handle(e);
                throw e;
            }
        };
    }

    private Runnable createWrappedRunnable(Runnable task) {
        return () -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.handle(e);
            }
        };
    }

    public AsyncTaskExecutorDescription describeJson() {
        return AsyncTaskExecutorDescription.build(this);
    }

    @Generated
    public ExceptionHandlingTaskExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public static class AsyncTaskExecutorDescription
    implements Serializable {
        int corePoolSize = -1;
        int activeCount = -1;
        int poolSize = -1;
        int queueSize = -1;
        long completeTasks = -1L;

        public String toString() {
            return "AsyncTaskExecutor[corePoolSize=" + this.corePoolSize + ",activeCount=" + this.activeCount + ",poolSize=" + this.poolSize + ",queueSize=" + this.queueSize + ",completeTasks=" + this.completeTasks + "]";
        }

        public static AsyncTaskExecutorDescription build(ExceptionHandlingTaskExecutor taskExecutor) {
            AsyncTaskExecutorDescription description = new AsyncTaskExecutorDescription();
            try {
                description.setCorePoolSize(taskExecutor.executor.getCorePoolSize());
                description.setActiveCount(taskExecutor.executor.getActiveCount());
                description.setPoolSize(taskExecutor.executor.getPoolSize());
                description.setQueueSize(taskExecutor.executor.getThreadPoolExecutor().getQueue().size());
                description.setCompleteTasks(taskExecutor.executor.getThreadPoolExecutor().getCompletedTaskCount());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return description;
        }

        @Generated
        public AsyncTaskExecutorDescription() {
        }

        @Generated
        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        @Generated
        public int getActiveCount() {
            return this.activeCount;
        }

        @Generated
        public int getPoolSize() {
            return this.poolSize;
        }

        @Generated
        public int getQueueSize() {
            return this.queueSize;
        }

        @Generated
        public long getCompleteTasks() {
            return this.completeTasks;
        }

        @Generated
        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        @Generated
        public void setActiveCount(int activeCount) {
            this.activeCount = activeCount;
        }

        @Generated
        public void setPoolSize(int poolSize) {
            this.poolSize = poolSize;
        }

        @Generated
        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        @Generated
        public void setCompleteTasks(long completeTasks) {
            this.completeTasks = completeTasks;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncTaskExecutorDescription)) {
                return false;
            }
            AsyncTaskExecutorDescription other = (AsyncTaskExecutorDescription)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCorePoolSize() != other.getCorePoolSize()) {
                return false;
            }
            if (this.getActiveCount() != other.getActiveCount()) {
                return false;
            }
            if (this.getPoolSize() != other.getPoolSize()) {
                return false;
            }
            if (this.getQueueSize() != other.getQueueSize()) {
                return false;
            }
            return this.getCompleteTasks() == other.getCompleteTasks();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncTaskExecutorDescription;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCorePoolSize();
            result = result * 59 + this.getActiveCount();
            result = result * 59 + this.getPoolSize();
            result = result * 59 + this.getQueueSize();
            long $completeTasks = this.getCompleteTasks();
            result = result * 59 + (int)($completeTasks >>> 32 ^ $completeTasks);
            return result;
        }
    }
}

