/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.cors;

import bikframework.web.cors.CorsProperties;
import java.util.Arrays;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@ConditionalOnProperty(prefix="bikframework.cors", name={"enable"}, havingValue="true")
@Configuration
@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsConfiguration {
    private final CorsProperties corsProperties;

    @Bean
    public CorsFilter corsFilter() {
        org.springframework.web.cors.CorsConfiguration corsConfiguration = new org.springframework.web.cors.CorsConfiguration();
        Arrays.stream(this.corsProperties.getAllowedOrigins()).forEach(arg_0 -> ((org.springframework.web.cors.CorsConfiguration)corsConfiguration).addAllowedOrigin(arg_0));
        Arrays.stream(this.corsProperties.getAllowedHeaders()).forEach(arg_0 -> ((org.springframework.web.cors.CorsConfiguration)corsConfiguration).addAllowedHeader(arg_0));
        Arrays.stream(this.corsProperties.getAllowedMethods()).forEach(arg_0 -> ((org.springframework.web.cors.CorsConfiguration)corsConfiguration).addAllowedMethod(arg_0));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        Arrays.stream(this.corsProperties.getUrlPatterns()).forEach(url -> source.registerCorsConfiguration(url, corsConfiguration));
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Generated
    public CorsConfiguration(CorsProperties corsProperties) {
        this.corsProperties = corsProperties;
    }
}

