/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.errormsg;

import bikframework.config.config.ConfigTools3;
import bikframework.utils.Base62Utils;
import bikframework.utils.data.type.LangUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;

public class ErrMsgBuilder {
    public static String getSeparatorChar() {
        return ".";
    }

    public static String encodeUserAlias(String userAlias) {
        return Base62Utils.longToBase62(userAlias);
    }

    @Deprecated
    public static String getErrMsgKey(String lang, int ret, int errCode) {
        String language = LangUtils.getOrDefaultLanguage(Strings.nullToEmpty((String)lang).toLowerCase());
        return Joiner.on((String)".").join((Object)language, (Object)ret, new Object[]{errCode});
    }

    public static String getErrMsgKey(String appId, String lang, int errCode) {
        String language = LangUtils.getOrDefaultLanguage(Strings.nullToEmpty((String)lang).toLowerCase());
        return Joiner.on((String)".").skipNulls().join((Object)appId, (Object)language, new Object[]{errCode});
    }

    public static String getErrMsgKey(String lang, int errCode) {
        return ErrMsgBuilder.getErrMsgKey(null, lang, errCode);
    }

    @Deprecated
    public static String getErrMsgDesc(String lang, int ret, int errCode, String defaultMsg) {
        String msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(lang, ret, errCode), defaultMsg);
        if (Strings.isNullOrEmpty((String)msg) && !LangUtils.isEnglish(lang)) {
            msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(LangUtils.LANG_EN, ret, errCode), defaultMsg);
        }
        return msg;
    }

    public static String getErrMsgDesc(String appId, String lang, int errCode, String defaultMsg) {
        String msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(appId, lang, errCode));
        if (Strings.isNullOrEmpty((String)msg)) {
            if (!LangUtils.isEnglish(lang)) {
                msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(appId, LangUtils.LANG_EN, errCode));
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(lang, errCode));
                }
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(LangUtils.LANG_EN, errCode));
                }
            } else {
                msg = ConfigTools3.getString(ErrMsgBuilder.getErrMsgKey(lang, errCode));
            }
        }
        if (Strings.isNullOrEmpty((String)msg)) {
            return defaultMsg;
        }
        return msg;
    }

    public static String fmtErrMsg(String userAlias, int errCode, String msg, String reason) {
        String errCodeTS = Base62Utils.longToBase62(System.currentTimeMillis() / 1000L);
        String errCodeId = Joiner.on((String)ErrMsgBuilder.getSeparatorChar()).join((Object)ErrMsgBuilder.encodeUserAlias(userAlias), (Object)errCodeTS, new Object[]{errCode});
        String errMsg = "NA";
        if (!Strings.isNullOrEmpty((String)msg)) {
            errMsg = msg;
        }
        if (!Strings.isNullOrEmpty((String)reason)) {
            errMsg = String.format("%s(%s)", "NA".equals(errMsg) ? "" : errMsg, reason);
        }
        return errCodeId + ":" + errMsg;
    }

    public static String getErrMsg(String appId, String lang, int errCode, String userAlias, String defaultMsg, String reason) {
        String msg = ErrMsgBuilder.getErrMsgDesc(appId, lang, errCode, defaultMsg);
        return ErrMsgBuilder.fmtErrMsg(userAlias, errCode, msg, reason);
    }

    public static String getErrMsg(String appId, String lang, int errCode, String userAlias, String defaultMsg) {
        return ErrMsgBuilder.getErrMsg(appId, lang, errCode, userAlias, defaultMsg, "");
    }

    public static String getErrMsg(String appId, String lang, int errCode, String userAlias) {
        return ErrMsgBuilder.getErrMsg(appId, lang, errCode, userAlias, "");
    }
}

