/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.errormsg;

import bikframework.config.config.ConfigTools3;
import bikframework.utils.Base62Utils;
import bikframework.utils.data.type.LangUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorMessageUtils.class);

    public static String getSeparatorChar() {
        return ".";
    }

    public static String encodeUserAlias(String userAlias) {
        if (Strings.isNullOrEmpty((String)userAlias)) {
            return "";
        }
        return Base62Utils.longToBase62(userAlias);
    }

    protected static String getErrMsgKey(String appId, String lang, int errCode) {
        String language = LangUtils.getOrDefaultLanguage(Strings.nullToEmpty((String)lang).toLowerCase());
        return Joiner.on((String)".").skipNulls().join((Object)appId, (Object)language, new Object[]{errCode});
    }

    protected static String getErrMsgKey(String lang, int errCode) {
        return ErrorMessageUtils.getErrMsgKey(null, lang, errCode);
    }

    public static String getErrMsgDesc(String appId, String lang, int errCode, String defaultMsg) {
        String msg = ConfigTools3.getString(ErrorMessageUtils.getErrMsgKey(appId, lang, errCode));
        if (Strings.isNullOrEmpty((String)msg)) {
            if (!LangUtils.isEnglish(lang)) {
                msg = ConfigTools3.getString(ErrorMessageUtils.getErrMsgKey(appId, LangUtils.LANG_EN, errCode));
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ConfigTools3.getString(ErrorMessageUtils.getErrMsgKey(lang, errCode));
                }
                if (Strings.isNullOrEmpty((String)msg)) {
                    msg = ConfigTools3.getString(ErrorMessageUtils.getErrMsgKey(LangUtils.LANG_EN, errCode));
                }
            } else {
                msg = ConfigTools3.getString(ErrorMessageUtils.getErrMsgKey(lang, errCode));
            }
        }
        if (Strings.isNullOrEmpty((String)msg)) {
            return defaultMsg;
        }
        return msg;
    }

    private static String fmtErrMsg(String userAlias, int errCode, String msg, String reason) {
        String errMsg = "NA";
        if (!Strings.isNullOrEmpty((String)msg)) {
            errMsg = msg;
        }
        if (!Strings.isNullOrEmpty((String)reason)) {
            errMsg = String.format("%s(%s)", "NA".equals(errMsg) ? "" : errMsg, reason);
        }
        if (Strings.isNullOrEmpty((String)userAlias)) {
            return errMsg;
        }
        String errCodeTS = Base62Utils.longToBase62(System.currentTimeMillis() / 1000L);
        String errCodeId = Joiner.on((String)ErrorMessageUtils.getSeparatorChar()).join((Object)ErrorMessageUtils.encodeUserAlias(userAlias), (Object)errCodeTS, new Object[]{errCode});
        return errCodeId + ":" + errMsg;
    }

    public static String getErrMsg(String appId, String lang, int errCode, String userAlias, String defaultMsg, String reason) {
        String msg = ErrorMessageUtils.getErrMsgDesc(appId, lang, errCode, defaultMsg);
        return ErrorMessageUtils.fmtErrMsg(userAlias, errCode, msg, reason);
    }

    public static String getErrMsg(String lang, int errCode, String defaultMsg, String userAlias, String appId) {
        return ErrorMessageUtils.getErrMsg(appId, lang, errCode, userAlias, defaultMsg, "");
    }

    public static String getErrMsg(String lang, int errCode, String defaultMsg, String userAlias) {
        return ErrorMessageUtils.getErrMsg(lang, errCode, defaultMsg, userAlias, null);
    }

    public static String getErrMsg(String lang, int errCode, String defaultMsg) {
        return ErrorMessageUtils.getErrMsg(lang, errCode, defaultMsg, "");
    }

    public static String getErrMsg(int errCode, String defaultMsg) {
        return ErrorMessageUtils.getErrMsg("", errCode, defaultMsg);
    }
}

