/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.exception;

import bikframework.web.domain.ApiException;
import bikframework.web.domain.ApiResponse;
import bikframework.web.domain.EAppApiErrCode;
import bikframework.web.exception.ExceptionHandlerStrategy;
import bikframework.web.exception.GlobalExceptionProperties;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Order(value=0)
@ControllerAdvice
@EnableConfigurationProperties(value={GlobalExceptionProperties.class})
@ConditionalOnProperty(prefix="bikframework.exception.handler", name={"domain"}, matchIfMissing=true, havingValue="vvf")
public class GlobalExceptionHandler
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final ApplicationContext applicationContext;
    private Map<String, ExceptionHandlerStrategy> exceptionHandlers = new HashMap<String, ExceptionHandlerStrategy>();
    private final GlobalExceptionProperties globalExceptionProperties;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().getParent() == null) {
            this.initExceptionHandlers();
        }
    }

    public void initExceptionHandlers() {
        log.info("Initializing exception handlers");
        try {
            this.exceptionHandlers = this.applicationContext.getBeansOfType(ExceptionHandlerStrategy.class).values().stream().collect(Collectors.toMap(ExceptionHandlerStrategy::getExceptionType, handler -> handler, (existing, replacement) -> {
                log.warn("Duplicate exception handler found for type: {}", (Object)existing.getExceptionType());
                return existing;
            }));
            if (this.exceptionHandlers == null) {
                this.exceptionHandlers = new HashMap<String, ExceptionHandlerStrategy>();
            }
            this.exceptionHandlers.forEach((key, value) -> log.info("Exception handler found for type: {}", key));
        }
        catch (Exception e) {
            log.error("Exception handler init error", (Throwable)e);
        }
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse missingParam(MissingServletRequestParameterException exception) {
        log.error("Handling MissingServletRequestParameterException: {}", (Object)exception.getMessage());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(MissingServletRequestParameterException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse httpMessageNotReadable(HttpMessageNotReadableException exception) {
        log.error("Handling HttpMessageNotReadableException: {}", (Object)exception.getMessage());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(HttpMessageNotReadableException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.SERVER_INTERNAL_ERROR.getCode());
        apiResponse.setMessage(EAppApiErrCode.SERVER_INTERNAL_ERROR.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse httpMediaTypeNotSupport(HttpMediaTypeNotSupportedException exception) {
        log.error("Handling HttpMediaTypeNotSupportedException: {}", (Object)exception.getMessage());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(HttpMediaTypeNotSupportedException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse methodNotSupport(HttpServletRequest request, HttpRequestMethodNotSupportedException exception) {
        log.error("Unsupported HTTP method: {} {}", (Object)request.getMethod(), (Object)request.getRequestURI());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(HttpRequestMethodNotSupportedException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        String httpMethod = request.getMethod().toUpperCase();
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> methodArgumentNotValidException(MethodArgumentNotValidException exception) {
        log.error("Handling MethodArgumentNotValidException: {}", (Object)exception.getMessage());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(MethodArgumentNotValidException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        if (this.globalExceptionProperties.isPrintableDetails()) {
            String msg = exception.getBindingResult().getFieldErrors().stream().map(n -> String.format("%s: %s", n.getField(), n.getDefaultMessage())).reduce((x, y) -> String.format("%s; %s", x, y)).orElse("Param invalid");
            ApiResponse<Object> apiResponse = new ApiResponse<Object>();
            apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
            apiResponse.setMessage(msg);
            return apiResponse;
        }
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> bindException(BindException exception) {
        log.error("Handling BindException: {}", (Object)exception.getMessage());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(BindException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        if (this.globalExceptionProperties.isPrintableDetails()) {
            String msg = exception.getBindingResult().getFieldErrors().stream().map(n -> String.format("%s: %s", n.getField(), n.getDefaultMessage())).reduce((x, y) -> String.format("%s; %s", x, y)).orElse("Param invalid");
            ApiResponse<Object> apiResponse = new ApiResponse<Object>();
            apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
            apiResponse.setMessage(msg);
            return apiResponse;
        }
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(EAppApiErrCode.INVALID_PARAMS.getCode());
        apiResponse.setMessage(EAppApiErrCode.INVALID_PARAMS.getDesc());
        return apiResponse;
    }

    @ExceptionHandler(value={ApiException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<Object> businessException(ApiException exception) {
        log.error("Business exception - Code: {}, Message: {}", (Object)exception.getErrCode(), (Object)exception.getMessage());
        ExceptionHandlerStrategy handler = this.exceptionHandlers.get(ApiException.class.getSimpleName());
        if (handler != null) {
            return handler.handle(exception, this.globalExceptionProperties);
        }
        ApiResponse<Object> apiResponse = new ApiResponse<Object>();
        apiResponse.setErrCode(exception.getErrCode());
        apiResponse.setMessage(exception.getMessage());
        return apiResponse;
    }

    @Generated
    public GlobalExceptionHandler(ApplicationContext applicationContext, GlobalExceptionProperties globalExceptionProperties) {
        this.applicationContext = applicationContext;
        this.globalExceptionProperties = globalExceptionProperties;
    }
}

