/*
 * Decompiled with CFR 0.152.
 */
package bikframework.web.xss;

import bikframework.web.xss.XssHttpServletRequestWrapper;
import bikframework.web.xss.XssProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class XssFilter
extends GenericFilterBean {
    private final XssProperties xssProperties;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestUri = httpServletRequest.getRequestURI();
        if (this.isExcludePath(requestUri)) {
            chain.doFilter(request, response);
            return;
        }
        chain.doFilter((ServletRequest)new XssHttpServletRequestWrapper((HttpServletRequest)request), response);
    }

    private boolean isExcludePath(String requestUri) {
        if (ArrayUtils.isEmpty((Object[])this.xssProperties.getExcludePatterns())) {
            return false;
        }
        for (String pattern : this.xssProperties.getExcludePatterns()) {
            if (!this.pathMatcher.match(pattern.trim(), requestUri)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public XssFilter(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

