/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.config;

import bikframework.config.config.AbstractConfigTools;
import bikframework.config.config.ConfigValueTools;
import bikframework.config.config.listener.IConfigChangeListener;
import bikframework.config.configcenter.ConfigCenterService;
import bikframework.config.configcenter.common.ConfigOverrideTools;
import bikframework.config.file.monitor.FileContentListener;
import bikframework.config.file.monitor.PathFileMonitor;
import bikframework.config.model.ConfigToolConfigDTO;
import bikframework.config.model.LocalConfigDTO;
import bikframework.config.model.SecretManagerConfig;
import bikframework.config.secret.AwsSecretsManagerUtil;
import com.google.common.base.Strings;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRouteTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigRouteTools.class);

    public void loadConfig(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        long start = System.currentTimeMillis();
        this.initParameter(configObj);
        switch (configObj.getRunMode()) {
            case 1: {
                this.localStart(configObj, listener);
                break;
            }
            case 2: {
                this.configCenterStart(configObj, listener);
                break;
            }
            case 3: {
                this.localStart(configObj, listener);
                this.configCenterStart(configObj, listener);
                break;
            }
        }
        logger.info("loading finished,runMode:[{}] time consume:[{}]s", (Object)configObj.getRunMode(), (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private void initParameter(ConfigToolConfigDTO configObj) {
        ConfigOverrideTools.initLevels(configObj.getProject(), configObj.getModule(), configObj.getEnv(), configObj.getRegion());
        ConfigValueTools.extSet = new HashSet<String>(configObj.getPropertiesExtension());
    }

    private void localStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        LocalConfigDTO localInitInfo = configObj.getLocalConfig();
        new PathFileMonitor(localInitInfo.getRefreshInterval()).monitorPath(AbstractConfigTools.replaceDirectoryPath(localInitInfo.getPath()), null, null, new FileContentListener(false, listener), localInitInfo.getRecursive()).start();
    }

    private void configCenterStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        new ConfigCenterService(configObj.getConfigCenterConfig()).load(listener);
        this.loadSecretsFromAws(configObj, listener);
    }

    private void loadSecretsFromAws(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        SecretManagerConfig secretCfg = configObj.getSecretManagerConfig();
        if (secretCfg != null && secretCfg.isValid()) {
            String prefix = "";
            prefix = this.appendPrefix(prefix, configObj.getProject());
            prefix = this.appendPrefix(prefix, configObj.getModule());
            prefix = this.appendPrefix(prefix, configObj.getEnv());
            prefix = this.appendPrefix(prefix, configObj.getRegion());
            String secretFilename = prefix + "SecretManager";
            ConfigValueTools.registerListener(secretFilename, 5, listener);
            try {
                String content = AwsSecretsManagerUtil.loadSecretsFromAws(secretCfg.getRegion(), secretCfg.getSecretName());
                ConfigValueTools.update(secretFilename, content);
            }
            catch (Exception ex) {
                logger.error("Failed load from aws secretmanager[region={}, name={}]. ERROR:", new Object[]{secretCfg.getRegion(), secretCfg.getSecretName(), ex});
            }
        }
    }

    private String appendPrefix(String prefix, String levelName) {
        if (!Strings.isNullOrEmpty((String)levelName)) {
            prefix = (String)prefix + levelName + ".";
        }
        return prefix;
    }
}

