/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.uuid;

import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.SplittableRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class Tsid
implements Serializable,
Comparable<Tsid> {
    private static final long serialVersionUID = -5446820982139116297L;
    private final long number;
    public static final int TSID_BYTES = 8;
    public static final int TSID_CHARS = 13;
    public static final long TSID_EPOCH;
    static final int RANDOM_BITS = 22;
    static final int RANDOM_MASK = 0x3FFFFF;
    static final int RANDOM_BITS_limit15 = 21;
    static final int RANDOM_MASK_limit15 = 0x1FFFFF;
    public static final long TSID_EPOCH_limit15;
    static final byte[] ALPHABET_VALUES;
    static final char[] ALPHABET_UPPERCASE;
    static final char[] ALPHABET_LOWERCASE;

    public Tsid(long number) {
        this.number = number;
    }

    public static Tsid from(long number) {
        return new Tsid(number);
    }

    public static Tsid from(byte[] bytes) {
        if (bytes == null || bytes.length != 8) {
            throw new IllegalArgumentException("Invalid TSID bytes");
        }
        long number = 0L;
        number |= ((long)bytes[0] & 0xFFL) << 56;
        number |= ((long)bytes[1] & 0xFFL) << 48;
        number |= ((long)bytes[2] & 0xFFL) << 40;
        number |= ((long)bytes[3] & 0xFFL) << 32;
        number |= ((long)bytes[4] & 0xFFL) << 24;
        number |= ((long)bytes[5] & 0xFFL) << 16;
        number |= ((long)bytes[6] & 0xFFL) << 8;
        return new Tsid(number |= (long)bytes[7] & 0xFFL);
    }

    public static Tsid from(String string) {
        char[] chars = Tsid.toCharArray(string);
        long number = 0L;
        number |= (long)ALPHABET_VALUES[chars[0]] << 60;
        number |= (long)ALPHABET_VALUES[chars[1]] << 55;
        number |= (long)ALPHABET_VALUES[chars[2]] << 50;
        number |= (long)ALPHABET_VALUES[chars[3]] << 45;
        number |= (long)ALPHABET_VALUES[chars[4]] << 40;
        number |= (long)ALPHABET_VALUES[chars[5]] << 35;
        number |= (long)ALPHABET_VALUES[chars[6]] << 30;
        number |= (long)ALPHABET_VALUES[chars[7]] << 25;
        number |= (long)ALPHABET_VALUES[chars[8]] << 20;
        number |= (long)ALPHABET_VALUES[chars[9]] << 15;
        number |= (long)ALPHABET_VALUES[chars[10]] << 10;
        number |= (long)ALPHABET_VALUES[chars[11]] << 5;
        return new Tsid(number |= (long)ALPHABET_VALUES[chars[12]]);
    }

    public long toLong() {
        return this.number;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.number >>> 56), (byte)(this.number >>> 48), (byte)(this.number >>> 40), (byte)(this.number >>> 32), (byte)(this.number >>> 24), (byte)(this.number >>> 16), (byte)(this.number >>> 8), (byte)this.number};
        return bytes;
    }

    public static Tsid fast() {
        long time = System.currentTimeMillis() - TSID_EPOCH << 22;
        long tail = LazyHolder.counter.incrementAndGet() & 0x3FFFFF;
        return new Tsid(time | tail);
    }

    public String toString() {
        return this.toString(ALPHABET_UPPERCASE);
    }

    public String toLowerCase() {
        return this.toString(ALPHABET_LOWERCASE);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getUnixMilliseconds());
    }

    public Instant getInstant(Instant customEpoch) {
        return Instant.ofEpochMilli(this.getUnixMilliseconds(customEpoch.toEpochMilli()));
    }

    public long getUnixMilliseconds() {
        return this.getTime() + TSID_EPOCH;
    }

    public long getUnixMilliseconds(long customEpoch) {
        return this.getTime() + customEpoch;
    }

    long getTime() {
        return this.number >>> 22;
    }

    long getRandom() {
        return this.number & 0x3FFFFFL;
    }

    public static boolean isValid(String string) {
        return string != null && Tsid.isValidCharArray(string.toCharArray());
    }

    public int hashCode() {
        return (int)(this.number ^ this.number >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != Tsid.class) {
            return false;
        }
        Tsid that = (Tsid)other;
        return this.number == that.number;
    }

    @Override
    public int compareTo(Tsid that) {
        long min = Long.MIN_VALUE;
        long a = this.number + Long.MIN_VALUE;
        long b = that.number + Long.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public String encode(int base) {
        return BaseN.encode(this, base);
    }

    public static Tsid decode(String string, int base) {
        return BaseN.decode(string, base);
    }

    public String format(String format) {
        if (format != null) {
            int i = format.indexOf(37);
            if (i < 0 || i == format.length() - 1) {
                throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
            }
            int longest = 20;
            char placeholder = format.charAt(i + 1);
            return new StringBuffer(format.length() + 20).append(format).replace(i, i + 2, switch (placeholder) {
                case 'S' -> this.toString();
                case 's' -> this.toLowerCase();
                case 'X' -> BaseN.encode(this, 16);
                case 'x' -> BaseN.encode(this, 16).toLowerCase();
                case 'd' -> BaseN.encode(this, 10);
                case 'z' -> BaseN.encode(this, 62);
                default -> throw new IllegalArgumentException(String.format("Invalid placeholder: \"%%%s\"", Character.valueOf(placeholder)));
            }).toString();
        }
        throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
    }

    public static Tsid unformat(String formatted, String format) {
        if (formatted != null && format != null) {
            int i = format.indexOf(37);
            if (i < 0 || i == format.length() - 1) {
                throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
            }
            String head = format.substring(0, i);
            String tail = format.substring(i + 2);
            char placeholder = format.charAt(i + 1);
            int length = formatted.length() - head.length() - tail.length();
            if (formatted.startsWith(head) && formatted.endsWith(tail)) {
                String substring = formatted.substring(i, i + length);
                switch (placeholder) {
                    case 'S': {
                        return Tsid.from(substring);
                    }
                    case 's': {
                        return Tsid.from(substring);
                    }
                    case 'X': {
                        return BaseN.decode(substring.toUpperCase(), 16);
                    }
                    case 'x': {
                        return BaseN.decode(substring.toUpperCase(), 16);
                    }
                    case 'd': {
                        return BaseN.decode(substring, 10);
                    }
                    case 'z': {
                        return BaseN.decode(substring, 62);
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid placeholder: \"%%%s\"", Character.valueOf(placeholder)));
            }
        }
        throw new IllegalArgumentException(String.format("Invalid formatted string: \"%s\"", formatted));
    }

    String toString(char[] alphabet) {
        char[] chars = new char[]{alphabet[(int)(this.number >>> 60 & 0x1FL)], alphabet[(int)(this.number >>> 55 & 0x1FL)], alphabet[(int)(this.number >>> 50 & 0x1FL)], alphabet[(int)(this.number >>> 45 & 0x1FL)], alphabet[(int)(this.number >>> 40 & 0x1FL)], alphabet[(int)(this.number >>> 35 & 0x1FL)], alphabet[(int)(this.number >>> 30 & 0x1FL)], alphabet[(int)(this.number >>> 25 & 0x1FL)], alphabet[(int)(this.number >>> 20 & 0x1FL)], alphabet[(int)(this.number >>> 15 & 0x1FL)], alphabet[(int)(this.number >>> 10 & 0x1FL)], alphabet[(int)(this.number >>> 5 & 0x1FL)], alphabet[(int)(this.number & 0x1FL)]};
        return new String(chars);
    }

    static char[] toCharArray(String string) {
        char[] chars;
        char[] cArray = chars = string == null ? null : string.toCharArray();
        if (!Tsid.isValidCharArray(chars)) {
            throw new IllegalArgumentException(String.format("Invalid TSID string: \"%s\"", string));
        }
        return chars;
    }

    static boolean isValidCharArray(char[] chars) {
        if (chars == null || chars.length != 13) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            try {
                if (ALPHABET_VALUES[chars[i]] != -1) continue;
                return false;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
        }
        return (ALPHABET_VALUES[chars[0]] & 0x10) == 0;
    }

    static {
        int i;
        TSID_EPOCH = Instant.parse("2020-01-01T00:00:00.000Z").toEpochMilli();
        TSID_EPOCH_limit15 = Instant.parse("2020-01-01T00:00:00.000Z").getEpochSecond();
        ALPHABET_VALUES = new byte[256];
        ALPHABET_UPPERCASE = "0123456789ABCDEFGHJKMNPQRSTVWXYZ".toCharArray();
        ALPHABET_LOWERCASE = "0123456789abcdefghjkmnpqrstvwxyz".toCharArray();
        Arrays.fill(ALPHABET_VALUES, (byte)-1);
        for (i = 0; i < ALPHABET_UPPERCASE.length; ++i) {
            Tsid.ALPHABET_VALUES[Tsid.ALPHABET_UPPERCASE[i]] = (byte)i;
        }
        for (i = 0; i < ALPHABET_LOWERCASE.length; ++i) {
            Tsid.ALPHABET_VALUES[Tsid.ALPHABET_LOWERCASE[i]] = (byte)i;
        }
        Tsid.ALPHABET_VALUES[79] = 0;
        Tsid.ALPHABET_VALUES[73] = 1;
        Tsid.ALPHABET_VALUES[76] = 1;
        Tsid.ALPHABET_VALUES[111] = 0;
        Tsid.ALPHABET_VALUES[105] = 1;
        Tsid.ALPHABET_VALUES[108] = 1;
    }

    private static class LazyHolder {
        private static final AtomicInteger counter = new AtomicInteger(new SplittableRandom().nextInt());

        private LazyHolder() {
        }
    }

    static class BaseN {
        static final BigInteger MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
        static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

        BaseN() {
        }

        static String encode(Tsid tsid, int base) {
            if (base < 2 || base > 62) {
                BaseN.exception(String.format("Invalid base: %s", base));
            }
            long x = tsid.number;
            int b = BaseN.length(base);
            char[] buffer = new char[b];
            while (Long.compareUnsigned(x, 0L) > 0) {
                long div = Long.divideUnsigned(x, base);
                long rem = Long.remainderUnsigned(x, base);
                buffer[--b] = ALPHABET.charAt((int)rem);
                x = div;
            }
            while (b > 0) {
                buffer[--b] = 48;
            }
            return new String(buffer);
        }

        static Tsid decode(String string, int base) {
            if (string == null) {
                BaseN.exception(String.format("Invalid base-%d string: null", base));
            }
            if (base < 2 || base > 62) {
                BaseN.exception(String.format("Invalid base: %s", base));
            }
            long x = 0L;
            long last = 0L;
            long plus = 0L;
            int length = BaseN.length(base);
            if (string.length() != length) {
                BaseN.exception(String.format("Invalid base-%d length: %s", base, string.length()));
            }
            for (int i = 0; i < length; ++i) {
                plus = ALPHABET.indexOf(string.charAt(i));
                if (plus == -1L) {
                    BaseN.exception(String.format("Invalid base-%d character: %s", base, Character.valueOf(string.charAt(i))));
                }
                last = x;
                x = x * (long)base + plus;
            }
            ByteBuffer buff = ByteBuffer.allocate(8);
            byte[] bytes = buff.putLong(last).array();
            BigInteger lazt = new BigInteger(1, bytes);
            BigInteger baze = BigInteger.valueOf(base);
            BigInteger pluz = BigInteger.valueOf(plus);
            if (lazt.multiply(baze).add(pluz).compareTo(MAX) > 0) {
                throw new IllegalArgumentException(String.format("Invalid base-%d value (overflow): %s", base, lazt));
            }
            return new Tsid(x);
        }

        private static int length(int base) {
            return (int)Math.ceil(64.0 / (Math.log(base) / Math.log(2.0)));
        }

        private static void exception(String string) {
            throw new IllegalArgumentException(string);
        }
    }
}

