/*
 * Decompiled with CFR 0.152.
 */
package bikframework.utils.uuid.listener;

import bikframework.utils.uuid.UniqueIdGenerator;
import bikframework.utils.uuid.annotation.GeneratedId;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable
public class IdGenerateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdGenerateListener.class);
    private static final Map<String, Field> ENTITY_ID_FIELDS = new ConcurrentHashMap<String, Field>(16);

    @PrePersist
    public void touchForCreate(Object entity) {
        if (null == entity) {
            return;
        }
        String entityClassName = entity.getClass().getName();
        Object idField = null;
        if (ENTITY_ID_FIELDS.containsKey(entityClassName)) {
            idField = ENTITY_ID_FIELDS.get(entityClassName);
            if (null == idField) {
                return;
            }
        } else {
            Object[] idFields = FieldUtils.getFieldsWithAnnotation(entity.getClass(), Id.class);
            if (ArrayUtils.isNotEmpty((Object[])idFields)) {
                idField = idFields[0];
            }
            ENTITY_ID_FIELDS.put(entityClassName, (Field)idField);
        }
        if (null == idField) {
            return;
        }
        try {
            Object idValue = FieldUtils.readField((Field)idField, (Object)entity, (boolean)true);
            if (null == idValue) {
                Object id = this.generateId((Field)idField);
                log.debug("Set id {} to entity {}", id, entity.getClass());
                FieldUtils.writeField((Field)idField, (Object)entity, (Object)id, (boolean)true);
            }
        }
        catch (IllegalAccessException e) {
            log.error("Cannot read or write id field value, entity {} , field {} ", new Object[]{entity, idField, e});
        }
    }

    private Object generateId(Field idField) {
        GeneratedId generatedId = idField.getAnnotation(GeneratedId.class);
        if (generatedId != null) {
            String methodName = generatedId.method();
            try {
                Method method = UniqueIdGenerator.class.getMethod(methodName, new Class[0]);
                return method.invoke((Object)UniqueIdGenerator.INSTANCE, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error invoking ID generation method: " + methodName, e);
            }
        }
        throw new IllegalArgumentException("Unsupported ID annotation on field: " + idField.getName());
    }
}

