/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.secret;

import bikframework.config.secret.SecretPropertyDecryptor;
import bikframework.config.secret.SecretPropertySourceLocator;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.cloud.nacos.config")
public class CustomNacosConfigProperties
extends NacosConfigProperties {
    private static final Logger logger = LoggerFactory.getLogger(SecretPropertySourceLocator.class);
    public static final String CONFIG_DECRYPTOR_CLASS = "bikframework.config.secret.decryptor";
    public static final String NACOS_ADDRESS = "spring.cloud.nacos.config.server-addr";
    public static final String NACOS_USERNAME = "spring.cloud.nacos.config.username";
    public static final String NACOS_PASSWORD = "spring.cloud.nacos.config.password";
    public static final String NACOS_ADDRESS2 = "spring.cloud.nacos.server-addr";
    public static final String NACOS_USERNAME2 = "spring.cloud.nacos.username";
    public static final String NACOS_PASSWORD2 = "spring.cloud.nacos.password";
    @Autowired
    private SecretPropertySourceLocator secretPropertySourceLocator;

    @PostConstruct
    public void init() {
        super.init();
        if (this.secretPropertySourceLocator != null) {
            String password;
            String username;
            Properties properties = this.secretPropertySourceLocator.loadSecretConfig();
            SecretPropertyDecryptor decryptor = this.buildDecryptor(properties);
            String serverAddr = this.getConfigItem(properties, NACOS_ADDRESS, NACOS_ADDRESS2);
            if (serverAddr != null && !serverAddr.isEmpty()) {
                this.setServerAddr(this.decrypt(decryptor, properties, serverAddr));
            }
            if ((username = this.getConfigItem(properties, NACOS_USERNAME, NACOS_USERNAME2)) != null && !username.isEmpty()) {
                this.setUsername(this.decrypt(decryptor, properties, username));
            }
            if ((password = this.getConfigItem(properties, NACOS_PASSWORD, NACOS_PASSWORD2)) != null && !password.isEmpty()) {
                this.setPassword(this.decrypt(decryptor, properties, password));
            }
        }
    }

    private String getConfigItem(Properties properties, String key, String failoverKey) {
        String value = properties.getOrDefault((Object)key, "").toString();
        if (value.isEmpty()) {
            value = properties.getOrDefault((Object)failoverKey, "").toString();
        }
        return value;
    }

    private SecretPropertyDecryptor buildDecryptor(Properties properties) {
        String clazzName = properties.getProperty(CONFIG_DECRYPTOR_CLASS);
        if (clazzName == null || clazzName.isEmpty()) {
            return null;
        }
        try {
            Class<?> aClass = Class.forName(clazzName);
            return (SecretPropertyDecryptor)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            logger.error("Failed create SecretPropertyDecryptor, DO NOT DECRYPT nacos connect secret. ERROR: ", (Throwable)ex);
            return null;
        }
    }

    private String decrypt(SecretPropertyDecryptor decryptor, Properties properties, String cipherText) {
        String plainText = null;
        if (decryptor != null) {
            plainText = decryptor.decrypt(cipherText, properties);
        }
        return plainText == null ? cipherText : plainText;
    }
}

