/*
 * Decompiled with CFR 0.152.
 */
package bikframework.config.secret;

import bikframework.config.secret.AwsSecretsManagerUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Order(value=-1)
public class SecretPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(SecretPropertySourceLocator.class);
    public static final String SECRET_PROPERTY_SOURCE_NAME = "SECRET";
    public static final String CONFIG_KEY_PREFIX = "bikframework.config.secret";
    public static final String PROP_APP_NAME = "spring.application.name";
    public static final String PROP_ACTIVE_PROFILE = "spring.profiles.active";
    private boolean initialized = false;
    private Properties bootProperties = new Properties();
    private final Map<String, Object> defaultConfig = new HashMap<String, Object>();
    private final Map<String, Object> sysConfig = new HashMap<String, Object>();
    private final Map<String, Object> appConfig = new HashMap<String, Object>();

    public PropertySource<?> locate(Environment environment) {
        this.loadSecretConfig();
        CompositePropertySource composite = new CompositePropertySource(SECRET_PROPERTY_SOURCE_NAME);
        boolean hasProp = false;
        if (!this.appConfig.isEmpty()) {
            composite.addPropertySource((PropertySource)new MapPropertySource("SECRET-app", this.appConfig));
            hasProp = true;
        }
        if (!this.sysConfig.isEmpty()) {
            composite.addPropertySource((PropertySource)new MapPropertySource("SECRET-sys", this.sysConfig));
            hasProp = true;
        }
        if (!this.defaultConfig.isEmpty()) {
            composite.addPropertySource((PropertySource)new MapPropertySource(SECRET_PROPERTY_SOURCE_NAME, this.defaultConfig));
            hasProp = true;
        }
        return hasProp ? composite : null;
    }

    public Properties loadSecretConfig() {
        if (!this.initialized) {
            this.bootProperties = this.loadBootstrapProperties("");
            Object activeProfile = this.bootProperties.get(PROP_ACTIVE_PROFILE);
            if (activeProfile != null) {
                this.bootProperties.putAll((Map<?, ?>)this.loadBootstrapProperties(activeProfile.toString()));
            }
            String jsonSecret = this.loadSecretFromAws(this.bootProperties);
            this.parseSecretConfig(this.bootProperties, jsonSecret);
            this.initialized = true;
        }
        Properties allProps = new Properties();
        allProps.putAll((Map<?, ?>)this.bootProperties);
        allProps.putAll(this.defaultConfig);
        allProps.putAll(this.sysConfig);
        allProps.putAll(this.appConfig);
        logger.info("allprops={}", (Object)allProps);
        return allProps;
    }

    private Properties loadBootstrapProperties(String profile) {
        String[] files = new String[]{"bootstrap", "application"};
        String[] ymlExts = new String[]{".yml", ".yaml"};
        String[] propExts = new String[]{".properties"};
        try {
            for (String f : files) {
                ClassPathResource resource;
                String filename = profile == null || profile.isEmpty() ? f : f + "-" + profile;
                for (String ext : ymlExts) {
                    resource = new ClassPathResource(filename + profile + ext);
                    if (!resource.exists()) continue;
                    YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                    yamlFactory.setResources(new Resource[]{resource});
                    return yamlFactory.getObject();
                }
                for (String ext : propExts) {
                    resource = new ClassPathResource(filename + ext);
                    if (!resource.exists()) continue;
                    PropertiesFactoryBean propFactory = new PropertiesFactoryBean();
                    propFactory.setLocation((Resource)resource);
                    return propFactory.getObject();
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed load bootstrap files {}. Error: ", (Object)files, (Object)e);
        }
        logger.error("Not found bootstrap file.");
        return new Properties();
    }

    private String loadSecretFromAws(Properties properties) {
        boolean secretEnable = "true".equalsIgnoreCase(properties.getProperty("bikframework.config.secret.enable"));
        if (!secretEnable) {
            return null;
        }
        String region = properties.getProperty("bikframework.config.secret.region");
        String secretName = properties.getProperty("bikframework.config.secret.secret-name");
        try {
            return AwsSecretsManagerUtil.loadSecretsFromAws(region, secretName);
        }
        catch (Exception ex) {
            logger.error("Failed load secrets from SecretManager. Error: ", (Throwable)ex);
            return null;
        }
    }

    private void parseSecretConfig(Properties properties, String jsonSecrets) {
        if (jsonSecrets == null || jsonSecrets.isEmpty()) {
            return;
        }
        String systemName = properties.getProperty("bikframework.config.secret.system-name");
        String appName = properties.getProperty(PROP_APP_NAME);
        String prefixSysItem = systemName + ".";
        String prefixAppItem = systemName + "." + appName + ".";
        try {
            Map mapRoot = (Map)new ObjectMapper().readValue(jsonSecrets, Map.class);
            HashMap<String, Object> mapSysConfig = new HashMap<String, Object>();
            HashMap mapAppConfig = new HashMap();
            mapRoot.forEach((rootKey, rootVal) -> {
                if (rootKey.equalsIgnoreCase(systemName) && rootVal instanceof Map) {
                    mapSysConfig.putAll((Map)rootVal);
                } else if (rootKey.startsWith(prefixAppItem)) {
                    String key = rootKey.substring(prefixAppItem.length());
                    this.appConfig.putIfAbsent(key, rootVal);
                } else if (rootKey.startsWith(prefixSysItem)) {
                    String key = rootKey.substring(prefixSysItem.length());
                    this.sysConfig.putIfAbsent(key, rootVal);
                } else {
                    this.defaultConfig.put((String)rootKey, rootVal);
                }
            });
            mapSysConfig.forEach((sysKey, sysVal) -> {
                if (sysKey.equalsIgnoreCase(appName) && sysVal instanceof Map) {
                    mapAppConfig.putAll((Map)sysVal);
                } else {
                    this.sysConfig.put((String)sysKey, sysVal);
                }
            });
            this.appConfig.putAll(mapAppConfig);
        }
        catch (Exception ex) {
            logger.error("Failed parse secrets config from SecretManager. ERROR: ", (Throwable)ex);
        }
    }
}

