/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.common;

import java.awt.Font;

public class FontWrapper {
    private Font font;
    private Float currentFontTopCoef;

    public FontWrapper(Font font) {
        this(font, 70);
    }

    public FontWrapper(Font font, int fontSize) {
        this.font = font;
        this.font = font.deriveFont(1, fontSize);
    }

    public float getCurrentFontTopCoef() {
        if (this.currentFontTopCoef != null) {
            return this.currentFontTopCoef.floatValue();
        }
        this.currentFontTopCoef = Float.valueOf(0.14645833f * (float)this.font.getSize() + 0.39583334f);
        return this.currentFontTopCoef.floatValue();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setCurrentFontTopCoef(Float currentFontTopCoef) {
        this.currentFontTopCoef = currentFontTopCoef;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FontWrapper)) {
            return false;
        }
        FontWrapper other = (FontWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Font this$font = this.getFont();
        Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !((Object)this$font).equals(other$font)) {
            return false;
        }
        return Float.compare(this.getCurrentFontTopCoef(), other.getCurrentFontTopCoef()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FontWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : ((Object)$font).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getCurrentFontTopCoef());
        return result;
    }

    public String toString() {
        return "FontWrapper(font=" + this.getFont() + ", currentFontTopCoef=" + this.getCurrentFontTopCoef() + ")";
    }

    public FontWrapper() {
    }

    public FontWrapper(Font font, Float currentFontTopCoef) {
        this.font = font;
        this.currentFontTopCoef = currentFontTopCoef;
    }
}

