/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.common.model.dto;

import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ResourceMap {
    private Map<String, Resource> resourceMap;
    private String tag;

    public ResourceMap(String tag) {
        this.tag = tag;
        this.resourceMap = new HashMap<String, Resource>();
    }

    public ResourceMap(String tag, int initialCapacity) {
        this.tag = tag;
        this.resourceMap = new HashMap<String, Resource>(initialCapacity);
    }

    public ResourceMap(int initialCapacity) {
        this.resourceMap = new HashMap<String, Resource>(initialCapacity);
    }

    public ResourceMap() {
    }

    private Map<String, Resource> getResourceMapOfCreate() {
        if (this.resourceMap == null) {
            this.resourceMap = new HashMap<String, Resource>(2);
        }
        return this.resourceMap;
    }

    public Resource put(String key, Resource value) {
        return this.getResourceMapOfCreate().put(key, value);
    }

    public Resource get(Object key) {
        return this.getResourceMapOfCreate().get(key);
    }

    public Resource remove(Object key) {
        return this.getResourceMapOfCreate().remove(key);
    }

    public Collection<Resource> values() {
        return this.getResourceMapOfCreate().values();
    }

    public void forEach(BiConsumer<String, Resource> action) {
        this.getResourceMapOfCreate().forEach(action);
    }

    public Map<String, Resource> getResourceMap() {
        return this.resourceMap;
    }

    public String getTag() {
        return this.tag;
    }

    public void setResourceMap(Map<String, Resource> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String toString() {
        return "ResourceMap(resourceMap=" + this.getResourceMap() + ", tag=" + this.getTag() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceMap)) {
            return false;
        }
        ResourceMap other = (ResourceMap)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Resource> this$resourceMap = this.getResourceMap();
        Map<String, Resource> other$resourceMap = other.getResourceMap();
        if (this$resourceMap == null ? other$resourceMap != null : !((Object)this$resourceMap).equals(other$resourceMap)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceMap;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Resource> $resourceMap = this.getResourceMap();
        result = result * 59 + ($resourceMap == null ? 43 : ((Object)$resourceMap).hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }
}

