/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.BaseAsymmetric;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractAsymmetricCrypto<T extends AbstractAsymmetricCrypto<T>>
extends BaseAsymmetric<T> {
    public AbstractAsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public abstract byte[] encrypt(byte[] var1, KeyType var2);

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.utf8Bytes(data), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes(data), keyType);
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr(this.encrypt(data, charset, keyType));
    }

    public abstract byte[] decrypt(byte[] var1, KeyType var2);

    public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data), keyType);
    }

    public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(SecureUtil.decode(data), keyType);
    }

    public String decryptStr(String data, KeyType keyType, Charset charset) {
        return StrUtil.str(this.decrypt(data, keyType), charset);
    }

    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        Assert.notNull(data, "Bcd string must be not null!", new Object[0]);
        byte[] dataBytes = BCD.ascToBcd(StrUtil.bytes((CharSequence)data, charset));
        return this.decrypt(dataBytes, keyType);
    }

    public String decryptStrFromBcd(String data, KeyType keyType, Charset charset) {
        return StrUtil.str(this.decryptFromBcd(data, keyType, charset), charset);
    }

    public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }
}

