/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.parser;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.Month;
import cn.hutool.core.date.Week;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronException;
import cn.hutool.cron.pattern.Part;
import cn.hutool.cron.pattern.matcher.AlwaysTrueMatcher;
import cn.hutool.cron.pattern.matcher.BoolArrayMatcher;
import cn.hutool.cron.pattern.matcher.DayOfMonthMatcher;
import cn.hutool.cron.pattern.matcher.PartMatcher;
import cn.hutool.cron.pattern.matcher.YearValueMatcher;
import java.util.ArrayList;
import java.util.List;

public class PartParser {
    private final Part part;

    public static PartParser of(Part part) {
        return new PartParser(part);
    }

    public PartParser(Part part) {
        this.part = part;
    }

    public PartMatcher parse(String value) {
        if (PartParser.isMatchAllStr(value)) {
            return new AlwaysTrueMatcher();
        }
        List<Integer> values = this.parseArray(value);
        if (values.isEmpty()) {
            throw new CronException("Invalid part value: [{}]", value);
        }
        switch (this.part) {
            case DAY_OF_MONTH: {
                return new DayOfMonthMatcher(values);
            }
            case YEAR: {
                return new YearValueMatcher(values);
            }
        }
        return new BoolArrayMatcher(values);
    }

    private List<Integer> parseArray(String value) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List<String> parts = StrUtil.split((CharSequence)value, ',');
        for (String part : parts) {
            CollUtil.addAllIfNotContains(values, this.parseStep(part));
        }
        return values;
    }

    private List<Integer> parseStep(String value) {
        List<Integer> results;
        List<String> parts = StrUtil.split((CharSequence)value, '/');
        int size = parts.size();
        if (size == 1) {
            results = this.parseRange(value, -1);
        } else if (size == 2) {
            int step = this.parseNumber(parts.get(1), false);
            if (step < 1) {
                throw new CronException("Non positive divisor for field: [{}]", value);
            }
            results = this.parseRange(parts.get(0), step);
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private List<Integer> parseRange(String value, int step) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value.length() <= 2) {
            int minValue = this.part.getMin();
            if (!PartParser.isMatchAllStr(value)) {
                minValue = Math.max(minValue, this.parseNumber(value, true));
            } else if (step < 1) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = this.part.getMax();
                if (minValue > maxValue) {
                    throw new CronException("Invalid value {} > {}", minValue, maxValue);
                }
                for (int i = minValue; i <= maxValue; i += step) {
                    results.add(i);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List<String> parts = StrUtil.split((CharSequence)value, '-');
        int size = parts.size();
        if (size == 1) {
            int v1 = this.parseNumber(value, true);
            if (step > 0) {
                NumberUtil.appendRange(v1, this.part.getMax(), step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = this.parseNumber(parts.get(0), true);
            int v2 = this.parseNumber(parts.get(1), true);
            if (step < 1) {
                step = 1;
            }
            if (v1 <= v2) {
                NumberUtil.appendRange(v1, v2, step, results);
            } else {
                NumberUtil.appendRange(v1, this.part.getMax(), step, results);
                NumberUtil.appendRange(this.part.getMin(), v2, step, results);
            }
        } else {
            throw new CronException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private static boolean isMatchAllStr(String value) {
        return 1 == value.length() && ("*".equals(value) || "?".equals(value));
    }

    private int parseNumber(String value, boolean checkValue) throws CronException {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            i = this.parseAlias(value);
        }
        if (i < 0) {
            i += this.part.getMax();
        }
        if (Part.DAY_OF_WEEK.equals((Object)this.part) && Week.SUNDAY.getIso8601Value() == i) {
            i = Week.SUNDAY.ordinal();
        }
        return checkValue ? this.part.checkValue(i) : i;
    }

    private int parseAlias(String name) throws CronException {
        if ("L".equalsIgnoreCase(name)) {
            return this.part.getMax();
        }
        switch (this.part) {
            case MONTH: {
                return Month.of(name).getValueBaseOne();
            }
            case DAY_OF_WEEK: {
                return Week.of(name).ordinal();
            }
        }
        throw new CronException("Invalid alias value: [{}]", name);
    }
}

