/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.util.StrUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;

public class TemporalAccessorUtil {
    public static int get(TemporalAccessor temporalAccessor, TemporalField field) {
        if (temporalAccessor.isSupported(field)) {
            return temporalAccessor.get(field);
        }
        return (int)field.range().getMinimum();
    }

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        return formatter.format(time);
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        DateTimeFormatter formatter = StrUtil.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return TemporalAccessorUtil.format(time, formatter);
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant result = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return result;
    }
}

