/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.codec;

import cn.hutool.core.codec.Decoder;
import cn.hutool.core.codec.Encoder;
import cn.hutool.core.util.StrUtil;
import java.util.Arrays;

public class Base58Codec
implements Encoder<byte[], String>,
Decoder<CharSequence, byte[]> {
    public static Base58Codec INSTANCE = new Base58Codec();
    private final char[] alphabet = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".toCharArray();
    private final char ENCODED_ZERO = this.alphabet[0];
    private final int[] lookup = this.initLookup();

    @Override
    public String encode(byte[] data) {
        int zeroCount;
        if (null == data) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        for (zeroCount = 0; zeroCount < data.length && data[zeroCount] == 0; ++zeroCount) {
        }
        data = Arrays.copyOf(data, data.length);
        char[] encoded = new char[data.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeroCount;
        while (inputStart < data.length) {
            encoded[--outputStart] = this.alphabet[Base58Codec.divmod(data, inputStart, 256, 58)];
            if (data[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == this.ENCODED_ZERO) {
            ++outputStart;
        }
        while (--zeroCount >= 0) {
            encoded[--outputStart] = this.ENCODED_ZERO;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    @Override
    public byte[] decode(CharSequence encoded) throws IllegalArgumentException {
        int zeros;
        if (encoded.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[encoded.length()];
        for (int i = 0; i < encoded.length(); ++i) {
            int digit;
            char c = encoded.charAt(i);
            int n = digit = c < '\u0080' ? this.lookup[c] : -1;
            if (digit < 0) {
                throw new IllegalArgumentException(StrUtil.format("Invalid char '{}' at [{}]", Character.valueOf(c), i));
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[encoded.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = Base58Codec.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }

    private int[] initLookup() {
        int[] lookup = new int[123];
        Arrays.fill(lookup, -1);
        for (int i = 0; i < this.alphabet.length; ++i) {
            lookup[this.alphabet[i]] = i;
        }
        return lookup;
    }

    private static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }
}

